/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Transport Request pickup date from Vendor Warehouse by Buyer")
public class CollectFreightPickupDetails {
    @SerializedName(value="requestedPickUp")
    private OffsetDateTime requestedPickUp = null;
    @SerializedName(value="scheduledPickUp")
    private OffsetDateTime scheduledPickUp = null;
    @SerializedName(value="carrierAssignmentDate")
    private OffsetDateTime carrierAssignmentDate = null;

    public CollectFreightPickupDetails requestedPickUp(OffsetDateTime requestedPickUp) {
        this.requestedPickUp = requestedPickUp;
        return this;
    }

    @Schema(description="Date on which the items can be picked up from vendor warehouse by Buyer used for WePay/Collect vendors.")
    public OffsetDateTime getRequestedPickUp() {
        return this.requestedPickUp;
    }

    public void setRequestedPickUp(OffsetDateTime requestedPickUp) {
        this.requestedPickUp = requestedPickUp;
    }

    public CollectFreightPickupDetails scheduledPickUp(OffsetDateTime scheduledPickUp) {
        this.scheduledPickUp = scheduledPickUp;
        return this;
    }

    @Schema(description="Date on which the items are scheduled to be picked from vendor warehouse by Buyer used for WePay/Collect vendors.")
    public OffsetDateTime getScheduledPickUp() {
        return this.scheduledPickUp;
    }

    public void setScheduledPickUp(OffsetDateTime scheduledPickUp) {
        this.scheduledPickUp = scheduledPickUp;
    }

    public CollectFreightPickupDetails carrierAssignmentDate(OffsetDateTime carrierAssignmentDate) {
        this.carrierAssignmentDate = carrierAssignmentDate;
        return this;
    }

    @Schema(description="Date on which the carrier is being scheduled to pickup items from vendor warehouse by Byer used for WePay/Collect vendors.")
    public OffsetDateTime getCarrierAssignmentDate() {
        return this.carrierAssignmentDate;
    }

    public void setCarrierAssignmentDate(OffsetDateTime carrierAssignmentDate) {
        this.carrierAssignmentDate = carrierAssignmentDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectFreightPickupDetails collectFreightPickupDetails = (CollectFreightPickupDetails)o;
        return Objects.equals(this.requestedPickUp, collectFreightPickupDetails.requestedPickUp) && Objects.equals(this.scheduledPickUp, collectFreightPickupDetails.scheduledPickUp) && Objects.equals(this.carrierAssignmentDate, collectFreightPickupDetails.carrierAssignmentDate);
    }

    public int hashCode() {
        return Objects.hash(this.requestedPickUp, this.scheduledPickUp, this.carrierAssignmentDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectFreightPickupDetails {\n");
        sb.append("    requestedPickUp: ").append(this.toIndentedString(this.requestedPickUp)).append("\n");
        sb.append("    scheduledPickUp: ").append(this.toIndentedString(this.scheduledPickUp)).append("\n");
        sb.append("    carrierAssignmentDate: ").append(this.toIndentedString(this.carrierAssignmentDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

