/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.OrderStatus;
import software.amazon.spapi.models.vendor.orders.v1.Pagination;

@Schema(description="A list of order statuses.")
public class OrderListStatus {
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="ordersStatus")
    private List<OrderStatus> ordersStatus = null;

    public OrderListStatus pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public OrderListStatus ordersStatus(List<OrderStatus> ordersStatus) {
        this.ordersStatus = ordersStatus;
        return this;
    }

    public OrderListStatus addOrdersStatusItem(OrderStatus ordersStatusItem) {
        if (this.ordersStatus == null) {
            this.ordersStatus = new ArrayList<OrderStatus>();
        }
        this.ordersStatus.add(ordersStatusItem);
        return this;
    }

    @Schema(description="Represents an order status within the OrderListStatus.")
    public List<OrderStatus> getOrdersStatus() {
        return this.ordersStatus;
    }

    public void setOrdersStatus(List<OrderStatus> ordersStatus) {
        this.ordersStatus = ordersStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderListStatus orderListStatus = (OrderListStatus)o;
        return Objects.equals(this.pagination, orderListStatus.pagination) && Objects.equals(this.ordersStatus, orderListStatus.ordersStatus);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.ordersStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderListStatus {\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    ordersStatus: ").append(this.toIndentedString(this.ordersStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

