/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;

@Schema(description="Item receive status at the buyer's warehouse.")
public class OrderItemStatusReceivingStatus {
    @SerializedName(value="receiveStatus")
    private ReceiveStatusEnum receiveStatus = null;
    @SerializedName(value="receivedQuantity")
    private ItemQuantity receivedQuantity = null;
    @SerializedName(value="lastReceiveDate")
    private OffsetDateTime lastReceiveDate = null;

    public OrderItemStatusReceivingStatus receiveStatus(ReceiveStatusEnum receiveStatus) {
        this.receiveStatus = receiveStatus;
        return this;
    }

    @Schema(description="Receive status of the line item.")
    public ReceiveStatusEnum getReceiveStatus() {
        return this.receiveStatus;
    }

    public void setReceiveStatus(ReceiveStatusEnum receiveStatus) {
        this.receiveStatus = receiveStatus;
    }

    public OrderItemStatusReceivingStatus receivedQuantity(ItemQuantity receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getReceivedQuantity() {
        return this.receivedQuantity;
    }

    public void setReceivedQuantity(ItemQuantity receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }

    public OrderItemStatusReceivingStatus lastReceiveDate(OffsetDateTime lastReceiveDate) {
        this.lastReceiveDate = lastReceiveDate;
        return this;
    }

    @Schema(description="The date when the most recent item was received at the buyer's warehouse. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getLastReceiveDate() {
        return this.lastReceiveDate;
    }

    public void setLastReceiveDate(OffsetDateTime lastReceiveDate) {
        this.lastReceiveDate = lastReceiveDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemStatusReceivingStatus orderItemStatusReceivingStatus = (OrderItemStatusReceivingStatus)o;
        return Objects.equals((Object)this.receiveStatus, (Object)orderItemStatusReceivingStatus.receiveStatus) && Objects.equals(this.receivedQuantity, orderItemStatusReceivingStatus.receivedQuantity) && Objects.equals(this.lastReceiveDate, orderItemStatusReceivingStatus.lastReceiveDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.receiveStatus, this.receivedQuantity, this.lastReceiveDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemStatusReceivingStatus {\n");
        sb.append("    receiveStatus: ").append(this.toIndentedString((Object)this.receiveStatus)).append("\n");
        sb.append("    receivedQuantity: ").append(this.toIndentedString(this.receivedQuantity)).append("\n");
        sb.append("    lastReceiveDate: ").append(this.toIndentedString(this.lastReceiveDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReceiveStatusEnum {
        NOT_RECEIVED("NOT_RECEIVED"),
        PARTIALLY_RECEIVED("PARTIALLY_RECEIVED"),
        RECEIVED("RECEIVED");

        private String value;

        private ReceiveStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReceiveStatusEnum fromValue(String input) {
            for (ReceiveStatusEnum b : ReceiveStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ReceiveStatusEnum> {
            public void write(JsonWriter jsonWriter, ReceiveStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ReceiveStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReceiveStatusEnum.fromValue(value);
            }
        }
    }
}

