/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.orders.v1.Money;

@Schema(description="Represents an individual item in an order, including item details, quantities, pricing, and backorder information.")
public class OrderItem {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="amazonProductIdentifier")
    private String amazonProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="orderedQuantity")
    private ItemQuantity orderedQuantity = null;
    @SerializedName(value="isBackOrderAllowed")
    private Boolean isBackOrderAllowed = null;
    @SerializedName(value="netCost")
    private Money netCost = null;
    @SerializedName(value="listPrice")
    private Money listPrice = null;

    public OrderItem itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Numbering of the item on the purchase order. The first item will be 1, the second 2, and so on.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public OrderItem amazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of an item.")
    public String getAmazonProductIdentifier() {
        return this.amazonProductIdentifier;
    }

    public void setAmazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
    }

    public OrderItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public OrderItem orderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getOrderedQuantity() {
        return this.orderedQuantity;
    }

    public void setOrderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public OrderItem isBackOrderAllowed(Boolean isBackOrderAllowed) {
        this.isBackOrderAllowed = isBackOrderAllowed;
        return this;
    }

    @Schema(required=true, description="When true, we will accept backorder confirmations for this item.")
    public Boolean isIsBackOrderAllowed() {
        return this.isBackOrderAllowed;
    }

    public void setIsBackOrderAllowed(Boolean isBackOrderAllowed) {
        this.isBackOrderAllowed = isBackOrderAllowed;
    }

    public OrderItem netCost(Money netCost) {
        this.netCost = netCost;
        return this;
    }

    @Schema(description="")
    public Money getNetCost() {
        return this.netCost;
    }

    public void setNetCost(Money netCost) {
        this.netCost = netCost;
    }

    public OrderItem listPrice(Money listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Schema(description="")
    public Money getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(Money listPrice) {
        this.listPrice = listPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.itemSequenceNumber, orderItem.itemSequenceNumber) && Objects.equals(this.amazonProductIdentifier, orderItem.amazonProductIdentifier) && Objects.equals(this.vendorProductIdentifier, orderItem.vendorProductIdentifier) && Objects.equals(this.orderedQuantity, orderItem.orderedQuantity) && Objects.equals(this.isBackOrderAllowed, orderItem.isBackOrderAllowed) && Objects.equals(this.netCost, orderItem.netCost) && Objects.equals(this.listPrice, orderItem.listPrice);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.amazonProductIdentifier, this.vendorProductIdentifier, this.orderedQuantity, this.isBackOrderAllowed, this.netCost, this.listPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    amazonProductIdentifier: ").append(this.toIndentedString(this.amazonProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    orderedQuantity: ").append(this.toIndentedString(this.orderedQuantity)).append("\n");
        sb.append("    isBackOrderAllowed: ").append(this.toIndentedString(this.isBackOrderAllowed)).append("\n");
        sb.append("    netCost: ").append(this.toIndentedString(this.netCost)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

