/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ImportDetails;
import software.amazon.spapi.models.vendor.orders.v1.OrderItem;
import software.amazon.spapi.models.vendor.orders.v1.PartyIdentification;

@Schema(description="Details of an order.")
public class OrderDetails {
    @SerializedName(value="purchaseOrderDate")
    private OffsetDateTime purchaseOrderDate = null;
    @SerializedName(value="purchaseOrderChangedDate")
    private OffsetDateTime purchaseOrderChangedDate = null;
    @SerializedName(value="purchaseOrderStateChangedDate")
    private OffsetDateTime purchaseOrderStateChangedDate = null;
    @SerializedName(value="purchaseOrderType")
    private PurchaseOrderTypeEnum purchaseOrderType = null;
    @SerializedName(value="importDetails")
    private ImportDetails importDetails = null;
    @SerializedName(value="dealCode")
    private String dealCode = null;
    @SerializedName(value="paymentMethod")
    private PaymentMethodEnum paymentMethod = null;
    @SerializedName(value="buyingParty")
    private PartyIdentification buyingParty = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="billToParty")
    private PartyIdentification billToParty = null;
    @SerializedName(value="shipWindow")
    private String shipWindow = null;
    @SerializedName(value="deliveryWindow")
    private String deliveryWindow = null;
    @SerializedName(value="items")
    private List<OrderItem> items = new ArrayList<OrderItem>();

    public OrderDetails purchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
        return this;
    }

    @Schema(required=true, description="The date the purchase order was placed. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getPurchaseOrderDate() {
        return this.purchaseOrderDate;
    }

    public void setPurchaseOrderDate(OffsetDateTime purchaseOrderDate) {
        this.purchaseOrderDate = purchaseOrderDate;
    }

    public OrderDetails purchaseOrderChangedDate(OffsetDateTime purchaseOrderChangedDate) {
        this.purchaseOrderChangedDate = purchaseOrderChangedDate;
        return this;
    }

    @Schema(description="The date when purchase order was last changed by Amazon after the order was placed. This date will be greater than 'purchaseOrderDate'. This means the PO data was changed on that date and vendors are required to fulfill the  updated PO. The PO changes can be related to Item Quantity, Ship to Location, Ship Window etc. This field will not be present in orders that have not changed after creation. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getPurchaseOrderChangedDate() {
        return this.purchaseOrderChangedDate;
    }

    public void setPurchaseOrderChangedDate(OffsetDateTime purchaseOrderChangedDate) {
        this.purchaseOrderChangedDate = purchaseOrderChangedDate;
    }

    public OrderDetails purchaseOrderStateChangedDate(OffsetDateTime purchaseOrderStateChangedDate) {
        this.purchaseOrderStateChangedDate = purchaseOrderStateChangedDate;
        return this;
    }

    @Schema(required=true, description="The date when current purchase order state was changed. Current purchase order state is available in the field 'purchaseOrderState'. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getPurchaseOrderStateChangedDate() {
        return this.purchaseOrderStateChangedDate;
    }

    public void setPurchaseOrderStateChangedDate(OffsetDateTime purchaseOrderStateChangedDate) {
        this.purchaseOrderStateChangedDate = purchaseOrderStateChangedDate;
    }

    public OrderDetails purchaseOrderType(PurchaseOrderTypeEnum purchaseOrderType) {
        this.purchaseOrderType = purchaseOrderType;
        return this;
    }

    @Schema(description="Type of purchase order.")
    public PurchaseOrderTypeEnum getPurchaseOrderType() {
        return this.purchaseOrderType;
    }

    public void setPurchaseOrderType(PurchaseOrderTypeEnum purchaseOrderType) {
        this.purchaseOrderType = purchaseOrderType;
    }

    public OrderDetails importDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
        return this;
    }

    @Schema(description="")
    public ImportDetails getImportDetails() {
        return this.importDetails;
    }

    public void setImportDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
    }

    public OrderDetails dealCode(String dealCode) {
        this.dealCode = dealCode;
        return this;
    }

    @Schema(description="If requested by the recipient, this field will contain a promotional/deal number. The discount code line is optional. It is used to obtain a price discount on items on the order.")
    public String getDealCode() {
        return this.dealCode;
    }

    public void setDealCode(String dealCode) {
        this.dealCode = dealCode;
    }

    public OrderDetails paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="Payment method used.")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public OrderDetails buyingParty(PartyIdentification buyingParty) {
        this.buyingParty = buyingParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getBuyingParty() {
        return this.buyingParty;
    }

    public void setBuyingParty(PartyIdentification buyingParty) {
        this.buyingParty = buyingParty;
    }

    public OrderDetails sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public OrderDetails shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public OrderDetails billToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getBillToParty() {
        return this.billToParty;
    }

    public void setBillToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
    }

    public OrderDetails shipWindow(String shipWindow) {
        this.shipWindow = shipWindow;
        return this;
    }

    @Schema(description="")
    public String getShipWindow() {
        return this.shipWindow;
    }

    public void setShipWindow(String shipWindow) {
        this.shipWindow = shipWindow;
    }

    public OrderDetails deliveryWindow(String deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
        return this;
    }

    @Schema(description="")
    public String getDeliveryWindow() {
        return this.deliveryWindow;
    }

    public void setDeliveryWindow(String deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
    }

    public OrderDetails items(List<OrderItem> items) {
        this.items = items;
        return this;
    }

    public OrderDetails addItemsItem(OrderItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of items in this purchase order.")
    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDetails orderDetails = (OrderDetails)o;
        return Objects.equals(this.purchaseOrderDate, orderDetails.purchaseOrderDate) && Objects.equals(this.purchaseOrderChangedDate, orderDetails.purchaseOrderChangedDate) && Objects.equals(this.purchaseOrderStateChangedDate, orderDetails.purchaseOrderStateChangedDate) && Objects.equals((Object)this.purchaseOrderType, (Object)orderDetails.purchaseOrderType) && Objects.equals(this.importDetails, orderDetails.importDetails) && Objects.equals(this.dealCode, orderDetails.dealCode) && Objects.equals((Object)this.paymentMethod, (Object)orderDetails.paymentMethod) && Objects.equals(this.buyingParty, orderDetails.buyingParty) && Objects.equals(this.sellingParty, orderDetails.sellingParty) && Objects.equals(this.shipToParty, orderDetails.shipToParty) && Objects.equals(this.billToParty, orderDetails.billToParty) && Objects.equals(this.shipWindow, orderDetails.shipWindow) && Objects.equals(this.deliveryWindow, orderDetails.deliveryWindow) && Objects.equals(this.items, orderDetails.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderDate, this.purchaseOrderChangedDate, this.purchaseOrderStateChangedDate, this.purchaseOrderType, this.importDetails, this.dealCode, this.paymentMethod, this.buyingParty, this.sellingParty, this.shipToParty, this.billToParty, this.shipWindow, this.deliveryWindow, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderDetails {\n");
        sb.append("    purchaseOrderDate: ").append(this.toIndentedString(this.purchaseOrderDate)).append("\n");
        sb.append("    purchaseOrderChangedDate: ").append(this.toIndentedString(this.purchaseOrderChangedDate)).append("\n");
        sb.append("    purchaseOrderStateChangedDate: ").append(this.toIndentedString(this.purchaseOrderStateChangedDate)).append("\n");
        sb.append("    purchaseOrderType: ").append(this.toIndentedString((Object)this.purchaseOrderType)).append("\n");
        sb.append("    importDetails: ").append(this.toIndentedString(this.importDetails)).append("\n");
        sb.append("    dealCode: ").append(this.toIndentedString(this.dealCode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    buyingParty: ").append(this.toIndentedString(this.buyingParty)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    billToParty: ").append(this.toIndentedString(this.billToParty)).append("\n");
        sb.append("    shipWindow: ").append(this.toIndentedString(this.shipWindow)).append("\n");
        sb.append("    deliveryWindow: ").append(this.toIndentedString(this.deliveryWindow)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentMethodEnum {
        INVOICE("Invoice"),
        CONSIGNMENT("Consignment"),
        CREDITCARD("CreditCard"),
        PREPAID("Prepaid");

        private String value;

        private PaymentMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentMethodEnum fromValue(String input) {
            for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PaymentMethodEnum> {
            public void write(JsonWriter jsonWriter, PaymentMethodEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PaymentMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentMethodEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PurchaseOrderTypeEnum {
        REGULARORDER("RegularOrder"),
        CONSIGNEDORDER("ConsignedOrder"),
        NEWPRODUCTINTRODUCTION("NewProductIntroduction"),
        RUSHORDER("RushOrder");

        private String value;

        private PurchaseOrderTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PurchaseOrderTypeEnum fromValue(String input) {
            for (PurchaseOrderTypeEnum b : PurchaseOrderTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PurchaseOrderTypeEnum> {
            public void write(JsonWriter jsonWriter, PurchaseOrderTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PurchaseOrderTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PurchaseOrderTypeEnum.fromValue(value);
            }
        }
    }
}

