/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.orders.v1.Money;
import software.amazon.spapi.models.vendor.orders.v1.OrderItemAcknowledgement;

@Schema(description="Details of the item being acknowledged.")
public class OrderAcknowledgementItem {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="amazonProductIdentifier")
    private String amazonProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="orderedQuantity")
    private ItemQuantity orderedQuantity = null;
    @SerializedName(value="netCost")
    private Money netCost = null;
    @SerializedName(value="listPrice")
    private Money listPrice = null;
    @SerializedName(value="discountMultiplier")
    private String discountMultiplier = null;
    @SerializedName(value="itemAcknowledgements")
    private List<OrderItemAcknowledgement> itemAcknowledgements = new ArrayList<OrderItemAcknowledgement>();

    public OrderAcknowledgementItem itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(description="Line item sequence number for the item.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public OrderAcknowledgementItem amazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of an item.")
    public String getAmazonProductIdentifier() {
        return this.amazonProductIdentifier;
    }

    public void setAmazonProductIdentifier(String amazonProductIdentifier) {
        this.amazonProductIdentifier = amazonProductIdentifier;
    }

    public OrderAcknowledgementItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Should be the same as was sent in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public OrderAcknowledgementItem orderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getOrderedQuantity() {
        return this.orderedQuantity;
    }

    public void setOrderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public OrderAcknowledgementItem netCost(Money netCost) {
        this.netCost = netCost;
        return this;
    }

    @Schema(description="")
    public Money getNetCost() {
        return this.netCost;
    }

    public void setNetCost(Money netCost) {
        this.netCost = netCost;
    }

    public OrderAcknowledgementItem listPrice(Money listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Schema(description="")
    public Money getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(Money listPrice) {
        this.listPrice = listPrice;
    }

    public OrderAcknowledgementItem discountMultiplier(String discountMultiplier) {
        this.discountMultiplier = discountMultiplier;
        return this;
    }

    @Schema(description="The discount multiplier that should be applied to the price if a vendor sells books with a list price. This is a multiplier factor to arrive at a final discounted price. A multiplier of .90 would be the factor if a 10% discount is given.")
    public String getDiscountMultiplier() {
        return this.discountMultiplier;
    }

    public void setDiscountMultiplier(String discountMultiplier) {
        this.discountMultiplier = discountMultiplier;
    }

    public OrderAcknowledgementItem itemAcknowledgements(List<OrderItemAcknowledgement> itemAcknowledgements) {
        this.itemAcknowledgements = itemAcknowledgements;
        return this;
    }

    public OrderAcknowledgementItem addItemAcknowledgementsItem(OrderItemAcknowledgement itemAcknowledgementsItem) {
        this.itemAcknowledgements.add(itemAcknowledgementsItem);
        return this;
    }

    @Schema(required=true, description="This is used to indicate acknowledged quantity.")
    public List<OrderItemAcknowledgement> getItemAcknowledgements() {
        return this.itemAcknowledgements;
    }

    public void setItemAcknowledgements(List<OrderItemAcknowledgement> itemAcknowledgements) {
        this.itemAcknowledgements = itemAcknowledgements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAcknowledgementItem orderAcknowledgementItem = (OrderAcknowledgementItem)o;
        return Objects.equals(this.itemSequenceNumber, orderAcknowledgementItem.itemSequenceNumber) && Objects.equals(this.amazonProductIdentifier, orderAcknowledgementItem.amazonProductIdentifier) && Objects.equals(this.vendorProductIdentifier, orderAcknowledgementItem.vendorProductIdentifier) && Objects.equals(this.orderedQuantity, orderAcknowledgementItem.orderedQuantity) && Objects.equals(this.netCost, orderAcknowledgementItem.netCost) && Objects.equals(this.listPrice, orderAcknowledgementItem.listPrice) && Objects.equals(this.discountMultiplier, orderAcknowledgementItem.discountMultiplier) && Objects.equals(this.itemAcknowledgements, orderAcknowledgementItem.itemAcknowledgements);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.amazonProductIdentifier, this.vendorProductIdentifier, this.orderedQuantity, this.netCost, this.listPrice, this.discountMultiplier, this.itemAcknowledgements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAcknowledgementItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    amazonProductIdentifier: ").append(this.toIndentedString(this.amazonProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    orderedQuantity: ").append(this.toIndentedString(this.orderedQuantity)).append("\n");
        sb.append("    netCost: ").append(this.toIndentedString(this.netCost)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    discountMultiplier: ").append(this.toIndentedString(this.discountMultiplier)).append("\n");
        sb.append("    itemAcknowledgements: ").append(this.toIndentedString(this.itemAcknowledgements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

