/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.OrderAcknowledgementItem;
import software.amazon.spapi.models.vendor.orders.v1.PartyIdentification;

@Schema(description="Represents an acknowledgement for an order, including the purchase order number, selling party details, acknowledgement date, and a list of acknowledged items.")
public class OrderAcknowledgement {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="acknowledgementDate")
    private OffsetDateTime acknowledgementDate = null;
    @SerializedName(value="items")
    private List<OrderAcknowledgementItem> items = new ArrayList<OrderAcknowledgementItem>();

    public OrderAcknowledgement purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public OrderAcknowledgement sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public OrderAcknowledgement acknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
        return this;
    }

    @Schema(required=true, description="The date and time when the purchase order is acknowledged, in ISO-8601 date/time format.")
    public OffsetDateTime getAcknowledgementDate() {
        return this.acknowledgementDate;
    }

    public void setAcknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
    }

    public OrderAcknowledgement items(List<OrderAcknowledgementItem> items) {
        this.items = items;
        return this;
    }

    public OrderAcknowledgement addItemsItem(OrderAcknowledgementItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of the items being acknowledged with associated details.")
    public List<OrderAcknowledgementItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderAcknowledgementItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAcknowledgement orderAcknowledgement = (OrderAcknowledgement)o;
        return Objects.equals(this.purchaseOrderNumber, orderAcknowledgement.purchaseOrderNumber) && Objects.equals(this.sellingParty, orderAcknowledgement.sellingParty) && Objects.equals(this.acknowledgementDate, orderAcknowledgement.acknowledgementDate) && Objects.equals(this.items, orderAcknowledgement.items);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.sellingParty, this.acknowledgementDate, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAcknowledgement {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    acknowledgementDate: ").append(this.toIndentedString(this.acknowledgementDate)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

