/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="An amount of money. Includes the currency code and an optional unit of measure for items priced by weight.")
public class Money {
    @SerializedName(value="currencyCode")
    private String currencyCode = null;
    @SerializedName(value="amount")
    private String amount = null;
    @SerializedName(value="unitOfMeasure")
    private UnitOfMeasureEnum unitOfMeasure = null;

    public Money currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="Three digit currency code in ISO 4217 format. String of length 3.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Money amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Money unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="The unit of measure for prices of items sold by weight. If this field is absent, the item is sold by eaches.")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return Objects.equals(this.currencyCode, money.currencyCode) && Objects.equals(this.amount, money.amount) && Objects.equals((Object)this.unitOfMeasure, (Object)money.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currencyCode, this.amount, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Money {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitOfMeasureEnum {
        POUNDS("POUNDS"),
        OUNCES("OUNCES"),
        GRAMS("GRAMS"),
        KILOGRAMS("KILOGRAMS");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitOfMeasureEnum fromValue(String input) {
            for (UnitOfMeasureEnum b : UnitOfMeasureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitOfMeasureEnum> {
            public void write(JsonWriter jsonWriter, UnitOfMeasureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitOfMeasureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitOfMeasureEnum.fromValue(value);
            }
        }
    }
}

