/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="The aggregate weight of this item being invoiced. This information will be available for items sold by weight.")
public class TotalWeight {
    @SerializedName(value="unitOfMeasure")
    private UnitOfMeasureEnum unitOfMeasure = null;
    @SerializedName(value="amount")
    private String amount = null;

    public TotalWeight unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(required=true, description="The unit of measure for items sold by weight.")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public TotalWeight amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Schema(required=true, description="")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TotalWeight totalWeight = (TotalWeight)o;
        return Objects.equals((Object)this.unitOfMeasure, (Object)totalWeight.unitOfMeasure) && Objects.equals(this.amount, totalWeight.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitOfMeasure, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TotalWeight {\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitOfMeasureEnum {
        POUNDS("POUNDS"),
        OUNCES("OUNCES"),
        GRAMS("GRAMS"),
        KILOGRAMS("KILOGRAMS");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitOfMeasureEnum fromValue(String input) {
            for (UnitOfMeasureEnum b : UnitOfMeasureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitOfMeasureEnum> {
            public void write(JsonWriter jsonWriter, UnitOfMeasureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitOfMeasureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitOfMeasureEnum.fromValue(value);
            }
        }
    }
}

