/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="References required in order to process a credit note. This information is required only if InvoiceType is CreditNote.")
public class CreditNoteDetails {
    @SerializedName(value="referenceInvoiceNumber")
    private String referenceInvoiceNumber = null;
    @SerializedName(value="debitNoteNumber")
    private String debitNoteNumber = null;
    @SerializedName(value="returnsReferenceNumber")
    private String returnsReferenceNumber = null;
    @SerializedName(value="goodsReturnDate")
    private OffsetDateTime goodsReturnDate = null;
    @SerializedName(value="rmaId")
    private String rmaId = null;
    @SerializedName(value="coopReferenceNumber")
    private String coopReferenceNumber = null;
    @SerializedName(value="consignorsReferenceNumber")
    private String consignorsReferenceNumber = null;

    public CreditNoteDetails referenceInvoiceNumber(String referenceInvoiceNumber) {
        this.referenceInvoiceNumber = referenceInvoiceNumber;
        return this;
    }

    @Schema(description="Original Invoice Number when sending a credit note relating to an existing invoice. One Invoice only to be processed per Credit Note. This is mandatory for AP Credit Notes.")
    public String getReferenceInvoiceNumber() {
        return this.referenceInvoiceNumber;
    }

    public void setReferenceInvoiceNumber(String referenceInvoiceNumber) {
        this.referenceInvoiceNumber = referenceInvoiceNumber;
    }

    public CreditNoteDetails debitNoteNumber(String debitNoteNumber) {
        this.debitNoteNumber = debitNoteNumber;
        return this;
    }

    @Schema(description="Debit Note Number as generated by Amazon. Recommended for Returns and COOP Credit Notes.")
    public String getDebitNoteNumber() {
        return this.debitNoteNumber;
    }

    public void setDebitNoteNumber(String debitNoteNumber) {
        this.debitNoteNumber = debitNoteNumber;
    }

    public CreditNoteDetails returnsReferenceNumber(String returnsReferenceNumber) {
        this.returnsReferenceNumber = returnsReferenceNumber;
        return this;
    }

    @Schema(description="Identifies the Returns Notice Number. Mandatory for all Returns Credit Notes.")
    public String getReturnsReferenceNumber() {
        return this.returnsReferenceNumber;
    }

    public void setReturnsReferenceNumber(String returnsReferenceNumber) {
        this.returnsReferenceNumber = returnsReferenceNumber;
    }

    public CreditNoteDetails goodsReturnDate(OffsetDateTime goodsReturnDate) {
        this.goodsReturnDate = goodsReturnDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getGoodsReturnDate() {
        return this.goodsReturnDate;
    }

    public void setGoodsReturnDate(OffsetDateTime goodsReturnDate) {
        this.goodsReturnDate = goodsReturnDate;
    }

    public CreditNoteDetails rmaId(String rmaId) {
        this.rmaId = rmaId;
        return this;
    }

    @Schema(description="Identifies the Returned Merchandise Authorization ID, if generated.")
    public String getRmaId() {
        return this.rmaId;
    }

    public void setRmaId(String rmaId) {
        this.rmaId = rmaId;
    }

    public CreditNoteDetails coopReferenceNumber(String coopReferenceNumber) {
        this.coopReferenceNumber = coopReferenceNumber;
        return this;
    }

    @Schema(description="Identifies the COOP reference used for COOP agreement. Failure to provide the COOP reference number or the Debit Note number may lead to a rejection of the Credit Note.")
    public String getCoopReferenceNumber() {
        return this.coopReferenceNumber;
    }

    public void setCoopReferenceNumber(String coopReferenceNumber) {
        this.coopReferenceNumber = coopReferenceNumber;
    }

    public CreditNoteDetails consignorsReferenceNumber(String consignorsReferenceNumber) {
        this.consignorsReferenceNumber = consignorsReferenceNumber;
        return this;
    }

    @Schema(description="Identifies the consignor reference number (VRET number), if generated by Amazon.")
    public String getConsignorsReferenceNumber() {
        return this.consignorsReferenceNumber;
    }

    public void setConsignorsReferenceNumber(String consignorsReferenceNumber) {
        this.consignorsReferenceNumber = consignorsReferenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditNoteDetails creditNoteDetails = (CreditNoteDetails)o;
        return Objects.equals(this.referenceInvoiceNumber, creditNoteDetails.referenceInvoiceNumber) && Objects.equals(this.debitNoteNumber, creditNoteDetails.debitNoteNumber) && Objects.equals(this.returnsReferenceNumber, creditNoteDetails.returnsReferenceNumber) && Objects.equals(this.goodsReturnDate, creditNoteDetails.goodsReturnDate) && Objects.equals(this.rmaId, creditNoteDetails.rmaId) && Objects.equals(this.coopReferenceNumber, creditNoteDetails.coopReferenceNumber) && Objects.equals(this.consignorsReferenceNumber, creditNoteDetails.consignorsReferenceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.referenceInvoiceNumber, this.debitNoteNumber, this.returnsReferenceNumber, this.goodsReturnDate, this.rmaId, this.coopReferenceNumber, this.consignorsReferenceNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditNoteDetails {\n");
        sb.append("    referenceInvoiceNumber: ").append(this.toIndentedString(this.referenceInvoiceNumber)).append("\n");
        sb.append("    debitNoteNumber: ").append(this.toIndentedString(this.debitNoteNumber)).append("\n");
        sb.append("    returnsReferenceNumber: ").append(this.toIndentedString(this.returnsReferenceNumber)).append("\n");
        sb.append("    goodsReturnDate: ").append(this.toIndentedString(this.goodsReturnDate)).append("\n");
        sb.append("    rmaId: ").append(this.toIndentedString(this.rmaId)).append("\n");
        sb.append("    coopReferenceNumber: ").append(this.toIndentedString(this.coopReferenceNumber)).append("\n");
        sb.append("    consignorsReferenceNumber: ").append(this.toIndentedString(this.consignorsReferenceNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

