/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Address;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.ShipmentSchedule;

@Schema(description="Details for the shipment status update given by the vendor for the specific package.")
public class StatusUpdateDetails {
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="statusCode")
    private String statusCode = null;
    @SerializedName(value="reasonCode")
    private String reasonCode = null;
    @SerializedName(value="statusDateTime")
    private OffsetDateTime statusDateTime = null;
    @SerializedName(value="statusLocationAddress")
    private Address statusLocationAddress = null;
    @SerializedName(value="shipmentSchedule")
    private ShipmentSchedule shipmentSchedule = null;

    public StatusUpdateDetails trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(required=true, description="The shipment tracking number is required for every package and should match the `trackingNumber` sent for the shipment confirmation.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public StatusUpdateDetails statusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Schema(required=true, description="Indicates the shipment status code of the package that provides transportation information for Amazon tracking systems and ultimately for the final customer. For more information, refer to the [Additional Fields Explanation](https://developer-docs.amazon.com/sp-api/docs/vendor-direct-fulfillment-shipping-api-use-case-guide#additional-fields-explanation).")
    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public StatusUpdateDetails reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Schema(required=true, description="Provides a reason code for the status of the package that will provide additional information about the transportation status. For more information, refer to the [Additional Fields Explanation](https://developer-docs.amazon.com/sp-api/docs/vendor-direct-fulfillment-shipping-api-use-case-guide#additional-fields-explanation).")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public StatusUpdateDetails statusDateTime(OffsetDateTime statusDateTime) {
        this.statusDateTime = statusDateTime;
        return this;
    }

    @Schema(required=true, description="The date and time when the shipment status was updated. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format, with UTC time zone or UTC offset. For example, 2020-07-16T23:00:00Z or 2020-07-16T23:00:00+01:00.")
    public OffsetDateTime getStatusDateTime() {
        return this.statusDateTime;
    }

    public void setStatusDateTime(OffsetDateTime statusDateTime) {
        this.statusDateTime = statusDateTime;
    }

    public StatusUpdateDetails statusLocationAddress(Address statusLocationAddress) {
        this.statusLocationAddress = statusLocationAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getStatusLocationAddress() {
        return this.statusLocationAddress;
    }

    public void setStatusLocationAddress(Address statusLocationAddress) {
        this.statusLocationAddress = statusLocationAddress;
    }

    public StatusUpdateDetails shipmentSchedule(ShipmentSchedule shipmentSchedule) {
        this.shipmentSchedule = shipmentSchedule;
        return this;
    }

    @Schema(description="")
    public ShipmentSchedule getShipmentSchedule() {
        return this.shipmentSchedule;
    }

    public void setShipmentSchedule(ShipmentSchedule shipmentSchedule) {
        this.shipmentSchedule = shipmentSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusUpdateDetails statusUpdateDetails = (StatusUpdateDetails)o;
        return Objects.equals(this.trackingNumber, statusUpdateDetails.trackingNumber) && Objects.equals(this.statusCode, statusUpdateDetails.statusCode) && Objects.equals(this.reasonCode, statusUpdateDetails.reasonCode) && Objects.equals(this.statusDateTime, statusUpdateDetails.statusDateTime) && Objects.equals(this.statusLocationAddress, statusUpdateDetails.statusLocationAddress) && Objects.equals(this.shipmentSchedule, statusUpdateDetails.shipmentSchedule);
    }

    public int hashCode() {
        return Objects.hash(this.trackingNumber, this.statusCode, this.reasonCode, this.statusDateTime, this.statusLocationAddress, this.shipmentSchedule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusUpdateDetails {\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    statusDateTime: ").append(this.toIndentedString(this.statusDateTime)).append("\n");
        sb.append("    statusLocationAddress: ").append(this.toIndentedString(this.statusLocationAddress)).append("\n");
        sb.append("    shipmentSchedule: ").append(this.toIndentedString(this.shipmentSchedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

