/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.payments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.payments.v1.ChargeDetails;
import software.amazon.spapi.models.vendor.df.payments.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.df.payments.v1.Money;
import software.amazon.spapi.models.vendor.df.payments.v1.TaxDetail;

@Schema(description="Provides the details of the items in this invoice.")
public class InvoiceItem {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="invoicedQuantity")
    private ItemQuantity invoicedQuantity = null;
    @SerializedName(value="netCost")
    private Money netCost = null;
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="vendorOrderNumber")
    private String vendorOrderNumber = null;
    @SerializedName(value="hsnCode")
    private String hsnCode = null;
    @SerializedName(value="taxDetails")
    private List<TaxDetail> taxDetails = null;
    @SerializedName(value="chargeDetails")
    private List<ChargeDetails> chargeDetails = null;

    public InvoiceItem itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Numbering of the item on the purchase order. The first item will be 1, the second 2, and so on.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public InvoiceItem buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Buyer's standard identification number (ASIN) of an item.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public InvoiceItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public InvoiceItem invoicedQuantity(ItemQuantity invoicedQuantity) {
        this.invoicedQuantity = invoicedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getInvoicedQuantity() {
        return this.invoicedQuantity;
    }

    public void setInvoicedQuantity(ItemQuantity invoicedQuantity) {
        this.invoicedQuantity = invoicedQuantity;
    }

    public InvoiceItem netCost(Money netCost) {
        this.netCost = netCost;
        return this;
    }

    @Schema(required=true, description="")
    public Money getNetCost() {
        return this.netCost;
    }

    public void setNetCost(Money netCost) {
        this.netCost = netCost;
    }

    public InvoiceItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number for this order. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public InvoiceItem vendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
        return this;
    }

    @Schema(description="The vendor's order number for this order.")
    public String getVendorOrderNumber() {
        return this.vendorOrderNumber;
    }

    public void setVendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
    }

    public InvoiceItem hsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
        return this;
    }

    @Schema(description="Harmonized System of Nomenclature (HSN) tax code. The HSN number cannot contain alphabets.")
    public String getHsnCode() {
        return this.hsnCode;
    }

    public void setHsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
    }

    public InvoiceItem taxDetails(List<TaxDetail> taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    public InvoiceItem addTaxDetailsItem(TaxDetail taxDetailsItem) {
        if (this.taxDetails == null) {
            this.taxDetails = new ArrayList<TaxDetail>();
        }
        this.taxDetails.add(taxDetailsItem);
        return this;
    }

    @Schema(description="Individual tax details per line item.")
    public List<TaxDetail> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetail> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public InvoiceItem chargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
        return this;
    }

    public InvoiceItem addChargeDetailsItem(ChargeDetails chargeDetailsItem) {
        if (this.chargeDetails == null) {
            this.chargeDetails = new ArrayList<ChargeDetails>();
        }
        this.chargeDetails.add(chargeDetailsItem);
        return this;
    }

    @Schema(description="Individual charge details per line item.")
    public List<ChargeDetails> getChargeDetails() {
        return this.chargeDetails;
    }

    public void setChargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItem invoiceItem = (InvoiceItem)o;
        return Objects.equals(this.itemSequenceNumber, invoiceItem.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, invoiceItem.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, invoiceItem.vendorProductIdentifier) && Objects.equals(this.invoicedQuantity, invoiceItem.invoicedQuantity) && Objects.equals(this.netCost, invoiceItem.netCost) && Objects.equals(this.purchaseOrderNumber, invoiceItem.purchaseOrderNumber) && Objects.equals(this.vendorOrderNumber, invoiceItem.vendorOrderNumber) && Objects.equals(this.hsnCode, invoiceItem.hsnCode) && Objects.equals(this.taxDetails, invoiceItem.taxDetails) && Objects.equals(this.chargeDetails, invoiceItem.chargeDetails);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.invoicedQuantity, this.netCost, this.purchaseOrderNumber, this.vendorOrderNumber, this.hsnCode, this.taxDetails, this.chargeDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    invoicedQuantity: ").append(this.toIndentedString(this.invoicedQuantity)).append("\n");
        sb.append("    netCost: ").append(this.toIndentedString(this.netCost)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    vendorOrderNumber: ").append(this.toIndentedString(this.vendorOrderNumber)).append("\n");
        sb.append("    hsnCode: ").append(this.toIndentedString(this.hsnCode)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    chargeDetails: ").append(this.toIndentedString(this.chargeDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

