/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.Money;

@Schema(description="The tax details for the order. _Note:_ Amazon calculates tax on the list price (Amazon retail price).")
public class TaxDetails {
    @SerializedName(value="taxRate")
    private String taxRate = null;
    @SerializedName(value="taxAmount")
    private Money taxAmount = null;
    @SerializedName(value="taxableAmount")
    private Money taxableAmount = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public TaxDetails taxRate(String taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Schema(description="")
    public String getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public TaxDetails taxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Money getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
    }

    public TaxDetails taxableAmount(Money taxableAmount) {
        this.taxableAmount = taxableAmount;
        return this;
    }

    @Schema(description="")
    public Money getTaxableAmount() {
        return this.taxableAmount;
    }

    public void setTaxableAmount(Money taxableAmount) {
        this.taxableAmount = taxableAmount;
    }

    public TaxDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(description="Tax type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxDetails taxDetails = (TaxDetails)o;
        return Objects.equals(this.taxRate, taxDetails.taxRate) && Objects.equals(this.taxAmount, taxDetails.taxAmount) && Objects.equals(this.taxableAmount, taxDetails.taxableAmount) && Objects.equals((Object)this.type, (Object)taxDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taxRate, this.taxAmount, this.taxableAmount, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxDetails {\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxableAmount: ").append(this.toIndentedString(this.taxableAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CONSUMPTION("CONSUMPTION"),
        GST("GST"),
        MWST_("MwSt."),
        PST("PST"),
        TOTAL("TOTAL"),
        TVA("TVA"),
        VAT("VAT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

