/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Dates for the scheduled delivery shipments.")
public class ScheduledDeliveryShipment {
    @SerializedName(value="scheduledDeliveryServiceType")
    private String scheduledDeliveryServiceType = null;
    @SerializedName(value="earliestNominatedDeliveryDate")
    private OffsetDateTime earliestNominatedDeliveryDate = null;
    @SerializedName(value="latestNominatedDeliveryDate")
    private OffsetDateTime latestNominatedDeliveryDate = null;

    public ScheduledDeliveryShipment scheduledDeliveryServiceType(String scheduledDeliveryServiceType) {
        this.scheduledDeliveryServiceType = scheduledDeliveryServiceType;
        return this;
    }

    @Schema(description="Scheduled delivery service type.")
    public String getScheduledDeliveryServiceType() {
        return this.scheduledDeliveryServiceType;
    }

    public void setScheduledDeliveryServiceType(String scheduledDeliveryServiceType) {
        this.scheduledDeliveryServiceType = scheduledDeliveryServiceType;
    }

    public ScheduledDeliveryShipment earliestNominatedDeliveryDate(OffsetDateTime earliestNominatedDeliveryDate) {
        this.earliestNominatedDeliveryDate = earliestNominatedDeliveryDate;
        return this;
    }

    @Schema(description="Earliest nominated delivery date for the scheduled delivery.")
    public OffsetDateTime getEarliestNominatedDeliveryDate() {
        return this.earliestNominatedDeliveryDate;
    }

    public void setEarliestNominatedDeliveryDate(OffsetDateTime earliestNominatedDeliveryDate) {
        this.earliestNominatedDeliveryDate = earliestNominatedDeliveryDate;
    }

    public ScheduledDeliveryShipment latestNominatedDeliveryDate(OffsetDateTime latestNominatedDeliveryDate) {
        this.latestNominatedDeliveryDate = latestNominatedDeliveryDate;
        return this;
    }

    @Schema(description="Latest nominated delivery date for the scheduled delivery.")
    public OffsetDateTime getLatestNominatedDeliveryDate() {
        return this.latestNominatedDeliveryDate;
    }

    public void setLatestNominatedDeliveryDate(OffsetDateTime latestNominatedDeliveryDate) {
        this.latestNominatedDeliveryDate = latestNominatedDeliveryDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledDeliveryShipment scheduledDeliveryShipment = (ScheduledDeliveryShipment)o;
        return Objects.equals(this.scheduledDeliveryServiceType, scheduledDeliveryShipment.scheduledDeliveryServiceType) && Objects.equals(this.earliestNominatedDeliveryDate, scheduledDeliveryShipment.earliestNominatedDeliveryDate) && Objects.equals(this.latestNominatedDeliveryDate, scheduledDeliveryShipment.latestNominatedDeliveryDate);
    }

    public int hashCode() {
        return Objects.hash(this.scheduledDeliveryServiceType, this.earliestNominatedDeliveryDate, this.latestNominatedDeliveryDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledDeliveryShipment {\n");
        sb.append("    scheduledDeliveryServiceType: ").append(this.toIndentedString(this.scheduledDeliveryServiceType)).append("\n");
        sb.append("    earliestNominatedDeliveryDate: ").append(this.toIndentedString(this.earliestNominatedDeliveryDate)).append("\n");
        sb.append("    latestNominatedDeliveryDate: ").append(this.toIndentedString(this.latestNominatedDeliveryDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

