/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.BuyerCustomizedInfoDetail;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.GiftDetails;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.ItemQuantity;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.Money;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.ScheduledDeliveryShipment;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.TaxItemDetails;

@Schema(description="An item within an order")
public class OrderItem {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="orderedQuantity")
    private ItemQuantity orderedQuantity = null;
    @SerializedName(value="scheduledDeliveryShipment")
    private ScheduledDeliveryShipment scheduledDeliveryShipment = null;
    @SerializedName(value="giftDetails")
    private GiftDetails giftDetails = null;
    @SerializedName(value="netPrice")
    private Money netPrice = null;
    @SerializedName(value="taxDetails")
    private TaxItemDetails taxDetails = null;
    @SerializedName(value="totalPrice")
    private Money totalPrice = null;
    @SerializedName(value="buyerCustomizedInfo")
    private BuyerCustomizedInfoDetail buyerCustomizedInfo = null;

    public OrderItem itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Numbering of the item on the purchase order. The first item will be 1, the second 2, and so on.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public OrderItem buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Buyer's standard identification number (ASIN) of an item.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public OrderItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public OrderItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="Title for the item.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OrderItem orderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getOrderedQuantity() {
        return this.orderedQuantity;
    }

    public void setOrderedQuantity(ItemQuantity orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public OrderItem scheduledDeliveryShipment(ScheduledDeliveryShipment scheduledDeliveryShipment) {
        this.scheduledDeliveryShipment = scheduledDeliveryShipment;
        return this;
    }

    @Schema(description="")
    public ScheduledDeliveryShipment getScheduledDeliveryShipment() {
        return this.scheduledDeliveryShipment;
    }

    public void setScheduledDeliveryShipment(ScheduledDeliveryShipment scheduledDeliveryShipment) {
        this.scheduledDeliveryShipment = scheduledDeliveryShipment;
    }

    public OrderItem giftDetails(GiftDetails giftDetails) {
        this.giftDetails = giftDetails;
        return this;
    }

    @Schema(description="")
    public GiftDetails getGiftDetails() {
        return this.giftDetails;
    }

    public void setGiftDetails(GiftDetails giftDetails) {
        this.giftDetails = giftDetails;
    }

    public OrderItem netPrice(Money netPrice) {
        this.netPrice = netPrice;
        return this;
    }

    @Schema(required=true, description="")
    public Money getNetPrice() {
        return this.netPrice;
    }

    public void setNetPrice(Money netPrice) {
        this.netPrice = netPrice;
    }

    public OrderItem taxDetails(TaxItemDetails taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    @Schema(description="")
    public TaxItemDetails getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(TaxItemDetails taxDetails) {
        this.taxDetails = taxDetails;
    }

    public OrderItem totalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Schema(description="")
    public Money getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
    }

    public OrderItem buyerCustomizedInfo(BuyerCustomizedInfoDetail buyerCustomizedInfo) {
        this.buyerCustomizedInfo = buyerCustomizedInfo;
        return this;
    }

    @Schema(description="")
    public BuyerCustomizedInfoDetail getBuyerCustomizedInfo() {
        return this.buyerCustomizedInfo;
    }

    public void setBuyerCustomizedInfo(BuyerCustomizedInfoDetail buyerCustomizedInfo) {
        this.buyerCustomizedInfo = buyerCustomizedInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.itemSequenceNumber, orderItem.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, orderItem.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, orderItem.vendorProductIdentifier) && Objects.equals(this.title, orderItem.title) && Objects.equals(this.orderedQuantity, orderItem.orderedQuantity) && Objects.equals(this.scheduledDeliveryShipment, orderItem.scheduledDeliveryShipment) && Objects.equals(this.giftDetails, orderItem.giftDetails) && Objects.equals(this.netPrice, orderItem.netPrice) && Objects.equals(this.taxDetails, orderItem.taxDetails) && Objects.equals(this.totalPrice, orderItem.totalPrice) && Objects.equals(this.buyerCustomizedInfo, orderItem.buyerCustomizedInfo);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.title, this.orderedQuantity, this.scheduledDeliveryShipment, this.giftDetails, this.netPrice, this.taxDetails, this.totalPrice, this.buyerCustomizedInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    orderedQuantity: ").append(this.toIndentedString(this.orderedQuantity)).append("\n");
        sb.append("    scheduledDeliveryShipment: ").append(this.toIndentedString(this.scheduledDeliveryShipment)).append("\n");
        sb.append("    giftDetails: ").append(this.toIndentedString(this.giftDetails)).append("\n");
        sb.append("    netPrice: ").append(this.toIndentedString(this.netPrice)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    buyerCustomizedInfo: ").append(this.toIndentedString(this.buyerCustomizedInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

