/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Details of quantity ordered.")
public class ItemQuantity {
    @SerializedName(value="amount")
    private Integer amount = null;
    @SerializedName(value="unitOfMeasure")
    private UnitOfMeasureEnum unitOfMeasure = null;

    public ItemQuantity amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="Acknowledged quantity. This value should not be zero.")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public ItemQuantity unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Unit of measure for the acknowledged quantity.")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemQuantity itemQuantity = (ItemQuantity)o;
        return Objects.equals(this.amount, itemQuantity.amount) && Objects.equals((Object)this.unitOfMeasure, (Object)itemQuantity.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemQuantity {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitOfMeasureEnum {
        EACH("Each");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitOfMeasureEnum fromValue(String input) {
            for (UnitOfMeasureEnum b : UnitOfMeasureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitOfMeasureEnum> {
            public void write(JsonWriter jsonWriter, UnitOfMeasureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitOfMeasureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitOfMeasureEnum.fromValue(value);
            }
        }
    }
}

