/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Status of acknowledgement.")
public class AcknowledgementStatus {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="description")
    private String description = null;

    public AcknowledgementStatus code(String code) {
        this.code = code;
        return this;
    }

    @Schema(description="Acknowledgement code is a unique two digit value which indicates the status of the acknowledgement. For a list of acknowledgement codes that Amazon supports, see the Vendor Direct Fulfillment APIs Use Case Guide.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public AcknowledgementStatus description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Reason for the acknowledgement code.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgementStatus acknowledgementStatus = (AcknowledgementStatus)o;
        return Objects.equals(this.code, acknowledgementStatus.code) && Objects.equals(this.description, acknowledgementStatus.description);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcknowledgementStatus {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

