/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.inventory.v1.ItemQuantity;

@Schema(description="Updated inventory details for an item.")
public class ItemDetails {
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="availableQuantity")
    private ItemQuantity availableQuantity = null;
    @SerializedName(value="isObsolete")
    private Boolean isObsolete = null;

    public ItemDetails buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="The buyer selected product identification of the item. Either buyerProductIdentifier or vendorProductIdentifier should be submitted.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public ItemDetails vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Either buyerProductIdentifier or vendorProductIdentifier should be submitted.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public ItemDetails availableQuantity(ItemQuantity availableQuantity) {
        this.availableQuantity = availableQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getAvailableQuantity() {
        return this.availableQuantity;
    }

    public void setAvailableQuantity(ItemQuantity availableQuantity) {
        this.availableQuantity = availableQuantity;
    }

    public ItemDetails isObsolete(Boolean isObsolete) {
        this.isObsolete = isObsolete;
        return this;
    }

    @Schema(description="When true, the item is permanently unavailable.")
    public Boolean isIsObsolete() {
        return this.isObsolete;
    }

    public void setIsObsolete(Boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDetails itemDetails = (ItemDetails)o;
        return Objects.equals(this.buyerProductIdentifier, itemDetails.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, itemDetails.vendorProductIdentifier) && Objects.equals(this.availableQuantity, itemDetails.availableQuantity) && Objects.equals(this.isObsolete, itemDetails.isObsolete);
    }

    public int hashCode() {
        return Objects.hash(this.buyerProductIdentifier, this.vendorProductIdentifier, this.availableQuantity, this.isObsolete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemDetails {\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    availableQuantity: ").append(this.toIndentedString(this.availableQuantity)).append("\n");
        sb.append("    isObsolete: ").append(this.toIndentedString(this.isObsolete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

