/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vehicles.v2024_11_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vehicles.v2024_11_01.Pagination;
import software.amazon.spapi.models.vehicles.v2024_11_01.Vehicle;

@Schema(description="Get paginated list of vehicle from Amazon's catalog")
public class VehiclesResponse {
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="vehicles")
    private List<Vehicle> vehicles = new ArrayList<Vehicle>();

    public VehiclesResponse pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public VehiclesResponse vehicles(List<Vehicle> vehicles) {
        this.vehicles = vehicles;
        return this;
    }

    public VehiclesResponse addVehiclesItem(Vehicle vehiclesItem) {
        this.vehicles.add(vehiclesItem);
        return this;
    }

    @Schema(required=true, description="List of vehicles from Amazon's catalog.")
    public List<Vehicle> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(List<Vehicle> vehicles) {
        this.vehicles = vehicles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehiclesResponse vehiclesResponse = (VehiclesResponse)o;
        return Objects.equals(this.pagination, vehiclesResponse.pagination) && Objects.equals(this.vehicles, vehiclesResponse.vehicles);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.vehicles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehiclesResponse {\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    vehicles: ").append(this.toIndentedString(this.vehicles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

