/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.solicitations.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Error response returned when the request is unsuccessful.")
public class Error {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="details")
    private String details = null;

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @Schema(required=true, description="An error code that identifies the type of error that occurred.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(required=true, description="A message that describes the error condition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error details(String details) {
        this.details = details;
        return this;
    }

    @Schema(description="Additional details that can help the caller understand or fix the issue.")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.message, error.message) && Objects.equals(this.details, error.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.details);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

