/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="The weight in the units indicated.")
public class Weight {
    @SerializedName(value="unit")
    private UnitEnum unit = null;
    @SerializedName(value="value")
    private BigDecimal value = null;

    public Weight unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @Schema(required=true, description="The unit of measurement.")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public Weight value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="The measurement value.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Weight weight = (Weight)o;
        return Objects.equals((Object)this.unit, (Object)weight.unit) && Objects.equals(this.value, weight.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unit, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Weight {\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        GRAM("GRAM"),
        KILOGRAM("KILOGRAM"),
        OUNCE("OUNCE"),
        POUND("POUND");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String input) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(value);
            }
        }
    }
}

