/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.DetailCodes;

@Schema(description="Contains detail codes that provide additional details related to the forward and return leg of the shipment.")
public class TrackingDetailCodes {
    @SerializedName(value="forward")
    private List<DetailCodes> forward = new ArrayList<DetailCodes>();
    @SerializedName(value="returns")
    private List<DetailCodes> returns = new ArrayList<DetailCodes>();

    public TrackingDetailCodes forward(List<DetailCodes> forward) {
        this.forward = forward;
        return this;
    }

    public TrackingDetailCodes addForwardItem(DetailCodes forwardItem) {
        this.forward.add(forwardItem);
        return this;
    }

    @Schema(required=true, description="Contains detail codes that provide additional details related to the forward leg of the shipment.")
    public List<DetailCodes> getForward() {
        return this.forward;
    }

    public void setForward(List<DetailCodes> forward) {
        this.forward = forward;
    }

    public TrackingDetailCodes returns(List<DetailCodes> returns) {
        this.returns = returns;
        return this;
    }

    public TrackingDetailCodes addReturnsItem(DetailCodes returnsItem) {
        this.returns.add(returnsItem);
        return this;
    }

    @Schema(required=true, description="Contains detail codes that provide additional details related to the return leg of the shipment.")
    public List<DetailCodes> getReturns() {
        return this.returns;
    }

    public void setReturns(List<DetailCodes> returns) {
        this.returns = returns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingDetailCodes trackingDetailCodes = (TrackingDetailCodes)o;
        return Objects.equals(this.forward, trackingDetailCodes.forward) && Objects.equals(this.returns, trackingDetailCodes.returns);
    }

    public int hashCode() {
        return Objects.hash(this.forward, this.returns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingDetailCodes {\n");
        sb.append("    forward: ").append(this.toIndentedString(this.forward)).append("\n");
        sb.append("    returns: ").append(this.toIndentedString(this.returns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

