/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.DocumentFormat;
import software.amazon.spapi.models.shipping.v2.DocumentSize;
import software.amazon.spapi.models.shipping.v2.DocumentType;
import software.amazon.spapi.models.shipping.v2.RequestedLabelCustomization;

@Schema(description="The document specifications requested. For calls to the purchaseShipment operation, the shipment purchase fails if the specified document specifications are not among those returned in the response to the getRates operation.")
public class RequestedDocumentSpecification {
    @SerializedName(value="format")
    private DocumentFormat format = null;
    @SerializedName(value="size")
    private DocumentSize size = null;
    @SerializedName(value="dpi")
    private Integer dpi = null;
    @SerializedName(value="pageLayout")
    private String pageLayout = null;
    @SerializedName(value="needFileJoining")
    private Boolean needFileJoining = null;
    @SerializedName(value="requestedDocumentTypes")
    private List<DocumentType> requestedDocumentTypes = new ArrayList<DocumentType>();
    @SerializedName(value="requestedLabelCustomization")
    private RequestedLabelCustomization requestedLabelCustomization = null;

    public RequestedDocumentSpecification format(DocumentFormat format) {
        this.format = format;
        return this;
    }

    @Schema(required=true, description="")
    public DocumentFormat getFormat() {
        return this.format;
    }

    public void setFormat(DocumentFormat format) {
        this.format = format;
    }

    public RequestedDocumentSpecification size(DocumentSize size) {
        this.size = size;
        return this;
    }

    @Schema(required=true, description="")
    public DocumentSize getSize() {
        return this.size;
    }

    public void setSize(DocumentSize size) {
        this.size = size;
    }

    public RequestedDocumentSpecification dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(description="")
    public Integer getDpi() {
        return this.dpi;
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public RequestedDocumentSpecification pageLayout(String pageLayout) {
        this.pageLayout = pageLayout;
        return this;
    }

    @Schema(description="")
    public String getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(String pageLayout) {
        this.pageLayout = pageLayout;
    }

    public RequestedDocumentSpecification needFileJoining(Boolean needFileJoining) {
        this.needFileJoining = needFileJoining;
        return this;
    }

    @Schema(required=true, description="")
    public Boolean getNeedFileJoining() {
        return this.needFileJoining;
    }

    public void setNeedFileJoining(Boolean needFileJoining) {
        this.needFileJoining = needFileJoining;
    }

    public RequestedDocumentSpecification requestedDocumentTypes(List<DocumentType> requestedDocumentTypes) {
        this.requestedDocumentTypes = requestedDocumentTypes;
        return this;
    }

    public RequestedDocumentSpecification addRequestedDocumentTypesItem(DocumentType requestedDocumentTypesItem) {
        this.requestedDocumentTypes.add(requestedDocumentTypesItem);
        return this;
    }

    @Schema(required=true, description="A list of the document types requested.")
    public List<DocumentType> getRequestedDocumentTypes() {
        return this.requestedDocumentTypes;
    }

    public void setRequestedDocumentTypes(List<DocumentType> requestedDocumentTypes) {
        this.requestedDocumentTypes = requestedDocumentTypes;
    }

    public RequestedDocumentSpecification requestedLabelCustomization(RequestedLabelCustomization requestedLabelCustomization) {
        this.requestedLabelCustomization = requestedLabelCustomization;
        return this;
    }

    @Schema(description="")
    public RequestedLabelCustomization getRequestedLabelCustomization() {
        return this.requestedLabelCustomization;
    }

    public void setRequestedLabelCustomization(RequestedLabelCustomization requestedLabelCustomization) {
        this.requestedLabelCustomization = requestedLabelCustomization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestedDocumentSpecification requestedDocumentSpecification = (RequestedDocumentSpecification)o;
        return Objects.equals((Object)this.format, (Object)requestedDocumentSpecification.format) && Objects.equals(this.size, requestedDocumentSpecification.size) && Objects.equals(this.dpi, requestedDocumentSpecification.dpi) && Objects.equals(this.pageLayout, requestedDocumentSpecification.pageLayout) && Objects.equals(this.needFileJoining, requestedDocumentSpecification.needFileJoining) && Objects.equals(this.requestedDocumentTypes, requestedDocumentSpecification.requestedDocumentTypes) && Objects.equals(this.requestedLabelCustomization, requestedDocumentSpecification.requestedLabelCustomization);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.size, this.dpi, this.pageLayout, this.needFileJoining, this.requestedDocumentTypes, this.requestedLabelCustomization});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestedDocumentSpecification {\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    pageLayout: ").append(this.toIndentedString(this.pageLayout)).append("\n");
        sb.append("    needFileJoining: ").append(this.toIndentedString(this.needFileJoining)).append("\n");
        sb.append("    requestedDocumentTypes: ").append(this.toIndentedString(this.requestedDocumentTypes)).append("\n");
        sb.append("    requestedLabelCustomization: ").append(this.toIndentedString(this.requestedLabelCustomization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

