/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.SupportedDocumentDetail;

@Schema(description="The format options available for a label.")
public class PrintOption {
    @SerializedName(value="supportedDPIs")
    private List<Integer> supportedDPIs = null;
    @SerializedName(value="supportedPageLayouts")
    private List<String> supportedPageLayouts = new ArrayList<String>();
    @SerializedName(value="supportedFileJoiningOptions")
    private List<Boolean> supportedFileJoiningOptions = new ArrayList<Boolean>();
    @SerializedName(value="supportedDocumentDetails")
    private List<SupportedDocumentDetail> supportedDocumentDetails = new ArrayList<SupportedDocumentDetail>();

    public PrintOption supportedDPIs(List<Integer> supportedDPIs) {
        this.supportedDPIs = supportedDPIs;
        return this;
    }

    public PrintOption addSupportedDPIsItem(Integer supportedDPIsItem) {
        if (this.supportedDPIs == null) {
            this.supportedDPIs = new ArrayList<Integer>();
        }
        this.supportedDPIs.add(supportedDPIsItem);
        return this;
    }

    @Schema(description="A list of the supported DPI options for a document.")
    public List<Integer> getSupportedDPIs() {
        return this.supportedDPIs;
    }

    public void setSupportedDPIs(List<Integer> supportedDPIs) {
        this.supportedDPIs = supportedDPIs;
    }

    public PrintOption supportedPageLayouts(List<String> supportedPageLayouts) {
        this.supportedPageLayouts = supportedPageLayouts;
        return this;
    }

    public PrintOption addSupportedPageLayoutsItem(String supportedPageLayoutsItem) {
        this.supportedPageLayouts.add(supportedPageLayoutsItem);
        return this;
    }

    @Schema(required=true, description="A list of the supported page layout options for a document.")
    public List<String> getSupportedPageLayouts() {
        return this.supportedPageLayouts;
    }

    public void setSupportedPageLayouts(List<String> supportedPageLayouts) {
        this.supportedPageLayouts = supportedPageLayouts;
    }

    public PrintOption supportedFileJoiningOptions(List<Boolean> supportedFileJoiningOptions) {
        this.supportedFileJoiningOptions = supportedFileJoiningOptions;
        return this;
    }

    public PrintOption addSupportedFileJoiningOptionsItem(Boolean supportedFileJoiningOptionsItem) {
        this.supportedFileJoiningOptions.add(supportedFileJoiningOptionsItem);
        return this;
    }

    @Schema(required=true, description="A list of the supported needFileJoining boolean values for a document.")
    public List<Boolean> getSupportedFileJoiningOptions() {
        return this.supportedFileJoiningOptions;
    }

    public void setSupportedFileJoiningOptions(List<Boolean> supportedFileJoiningOptions) {
        this.supportedFileJoiningOptions = supportedFileJoiningOptions;
    }

    public PrintOption supportedDocumentDetails(List<SupportedDocumentDetail> supportedDocumentDetails) {
        this.supportedDocumentDetails = supportedDocumentDetails;
        return this;
    }

    public PrintOption addSupportedDocumentDetailsItem(SupportedDocumentDetail supportedDocumentDetailsItem) {
        this.supportedDocumentDetails.add(supportedDocumentDetailsItem);
        return this;
    }

    @Schema(required=true, description="A list of the supported documented details.")
    public List<SupportedDocumentDetail> getSupportedDocumentDetails() {
        return this.supportedDocumentDetails;
    }

    public void setSupportedDocumentDetails(List<SupportedDocumentDetail> supportedDocumentDetails) {
        this.supportedDocumentDetails = supportedDocumentDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrintOption printOption = (PrintOption)o;
        return Objects.equals(this.supportedDPIs, printOption.supportedDPIs) && Objects.equals(this.supportedPageLayouts, printOption.supportedPageLayouts) && Objects.equals(this.supportedFileJoiningOptions, printOption.supportedFileJoiningOptions) && Objects.equals(this.supportedDocumentDetails, printOption.supportedDocumentDetails);
    }

    public int hashCode() {
        return Objects.hash(this.supportedDPIs, this.supportedPageLayouts, this.supportedFileJoiningOptions, this.supportedDocumentDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrintOption {\n");
        sb.append("    supportedDPIs: ").append(this.toIndentedString(this.supportedDPIs)).append("\n");
        sb.append("    supportedPageLayouts: ").append(this.toIndentedString(this.supportedPageLayouts)).append("\n");
        sb.append("    supportedFileJoiningOptions: ").append(this.toIndentedString(this.supportedFileJoiningOptions)).append("\n");
        sb.append("    supportedDocumentDetails: ").append(this.toIndentedString(this.supportedDocumentDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

