/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.Currency;
import software.amazon.spapi.models.shipping.v2.DangerousGoodsDetails;
import software.amazon.spapi.models.shipping.v2.DirectFulfillmentItemIdentifiers;
import software.amazon.spapi.models.shipping.v2.InvoiceDetails;
import software.amazon.spapi.models.shipping.v2.LiquidVolume;
import software.amazon.spapi.models.shipping.v2.Weight;

@Schema(description="An item in a package.")
public class Item {
    @SerializedName(value="itemValue")
    private Currency itemValue = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="itemIdentifier")
    private String itemIdentifier = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="liquidVolume")
    private LiquidVolume liquidVolume = null;
    @SerializedName(value="isHazmat")
    private Boolean isHazmat = null;
    @SerializedName(value="dangerousGoodsDetails")
    private DangerousGoodsDetails dangerousGoodsDetails = null;
    @SerializedName(value="productType")
    private String productType = null;
    @SerializedName(value="invoiceDetails")
    private InvoiceDetails invoiceDetails = null;
    @SerializedName(value="serialNumbers")
    private List<String> serialNumbers = null;
    @SerializedName(value="directFulfillmentItemIdentifiers")
    private DirectFulfillmentItemIdentifiers directFulfillmentItemIdentifiers = null;

    public Item itemValue(Currency itemValue) {
        this.itemValue = itemValue;
        return this;
    }

    @Schema(description="")
    public Currency getItemValue() {
        return this.itemValue;
    }

    public void setItemValue(Currency itemValue) {
        this.itemValue = itemValue;
    }

    public Item description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="The product description of the item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Item itemIdentifier(String itemIdentifier) {
        this.itemIdentifier = itemIdentifier;
        return this;
    }

    @Schema(description="A unique identifier for an item provided by the client.")
    public String getItemIdentifier() {
        return this.itemIdentifier;
    }

    public void setItemIdentifier(String itemIdentifier) {
        this.itemIdentifier = itemIdentifier;
    }

    public Item quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="The number of units. This value is required.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Item weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Item liquidVolume(LiquidVolume liquidVolume) {
        this.liquidVolume = liquidVolume;
        return this;
    }

    @Schema(description="")
    public LiquidVolume getLiquidVolume() {
        return this.liquidVolume;
    }

    public void setLiquidVolume(LiquidVolume liquidVolume) {
        this.liquidVolume = liquidVolume;
    }

    public Item isHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
        return this;
    }

    @Schema(description="When true, the item qualifies as hazardous materials (hazmat). Defaults to false.")
    public Boolean isIsHazmat() {
        return this.isHazmat;
    }

    public void setIsHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
    }

    public Item dangerousGoodsDetails(DangerousGoodsDetails dangerousGoodsDetails) {
        this.dangerousGoodsDetails = dangerousGoodsDetails;
        return this;
    }

    @Schema(description="")
    public DangerousGoodsDetails getDangerousGoodsDetails() {
        return this.dangerousGoodsDetails;
    }

    public void setDangerousGoodsDetails(DangerousGoodsDetails dangerousGoodsDetails) {
        this.dangerousGoodsDetails = dangerousGoodsDetails;
    }

    public Item productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Schema(description="The product type of the item.")
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public Item invoiceDetails(InvoiceDetails invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
        return this;
    }

    @Schema(description="")
    public InvoiceDetails getInvoiceDetails() {
        return this.invoiceDetails;
    }

    public void setInvoiceDetails(InvoiceDetails invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
    }

    public Item serialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
        return this;
    }

    public Item addSerialNumbersItem(String serialNumbersItem) {
        if (this.serialNumbers == null) {
            this.serialNumbers = new ArrayList<String>();
        }
        this.serialNumbers.add(serialNumbersItem);
        return this;
    }

    @Schema(description="A list of unique serial numbers in an Amazon package that can be used to guarantee non-fraudulent items. The number of serial numbers in the list must be less than or equal to the quantity of items being shipped. Only applicable when channel source is Amazon.")
    public List<String> getSerialNumbers() {
        return this.serialNumbers;
    }

    public void setSerialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    public Item directFulfillmentItemIdentifiers(DirectFulfillmentItemIdentifiers directFulfillmentItemIdentifiers) {
        this.directFulfillmentItemIdentifiers = directFulfillmentItemIdentifiers;
        return this;
    }

    @Schema(description="")
    public DirectFulfillmentItemIdentifiers getDirectFulfillmentItemIdentifiers() {
        return this.directFulfillmentItemIdentifiers;
    }

    public void setDirectFulfillmentItemIdentifiers(DirectFulfillmentItemIdentifiers directFulfillmentItemIdentifiers) {
        this.directFulfillmentItemIdentifiers = directFulfillmentItemIdentifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.itemValue, item.itemValue) && Objects.equals(this.description, item.description) && Objects.equals(this.itemIdentifier, item.itemIdentifier) && Objects.equals(this.quantity, item.quantity) && Objects.equals(this.weight, item.weight) && Objects.equals(this.liquidVolume, item.liquidVolume) && Objects.equals(this.isHazmat, item.isHazmat) && Objects.equals(this.dangerousGoodsDetails, item.dangerousGoodsDetails) && Objects.equals(this.productType, item.productType) && Objects.equals(this.invoiceDetails, item.invoiceDetails) && Objects.equals(this.serialNumbers, item.serialNumbers) && Objects.equals(this.directFulfillmentItemIdentifiers, item.directFulfillmentItemIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.itemValue, this.description, this.itemIdentifier, this.quantity, this.weight, this.liquidVolume, this.isHazmat, this.dangerousGoodsDetails, this.productType, this.invoiceDetails, this.serialNumbers, this.directFulfillmentItemIdentifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    itemValue: ").append(this.toIndentedString(this.itemValue)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    itemIdentifier: ").append(this.toIndentedString(this.itemIdentifier)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    liquidVolume: ").append(this.toIndentedString(this.liquidVolume)).append("\n");
        sb.append("    isHazmat: ").append(this.toIndentedString(this.isHazmat)).append("\n");
        sb.append("    dangerousGoodsDetails: ").append(this.toIndentedString(this.dangerousGoodsDetails)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    invoiceDetails: ").append(this.toIndentedString(this.invoiceDetails)).append("\n");
        sb.append("    serialNumbers: ").append(this.toIndentedString(this.serialNumbers)).append("\n");
        sb.append("    directFulfillmentItemIdentifiers: ").append(this.toIndentedString(this.directFulfillmentItemIdentifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

