/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.IneligibilityReason;

@Schema(description="Detailed information for an ineligible shipping service offering.")
public class IneligibleRate {
    @SerializedName(value="serviceId")
    private String serviceId = null;
    @SerializedName(value="serviceName")
    private String serviceName = null;
    @SerializedName(value="carrierName")
    private String carrierName = null;
    @SerializedName(value="carrierId")
    private String carrierId = null;
    @SerializedName(value="ineligibilityReasons")
    private List<IneligibilityReason> ineligibilityReasons = new ArrayList<IneligibilityReason>();

    public IneligibleRate serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public IneligibleRate serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Schema(required=true, description="")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public IneligibleRate carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @Schema(required=true, description="")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public IneligibleRate carrierId(String carrierId) {
        this.carrierId = carrierId;
        return this;
    }

    @Schema(required=true, description="")
    public String getCarrierId() {
        return this.carrierId;
    }

    public void setCarrierId(String carrierId) {
        this.carrierId = carrierId;
    }

    public IneligibleRate ineligibilityReasons(List<IneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
        return this;
    }

    public IneligibleRate addIneligibilityReasonsItem(IneligibilityReason ineligibilityReasonsItem) {
        this.ineligibilityReasons.add(ineligibilityReasonsItem);
        return this;
    }

    @Schema(required=true, description="A list of reasons why a shipping service offering is ineligible.")
    public List<IneligibilityReason> getIneligibilityReasons() {
        return this.ineligibilityReasons;
    }

    public void setIneligibilityReasons(List<IneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IneligibleRate ineligibleRate = (IneligibleRate)o;
        return Objects.equals(this.serviceId, ineligibleRate.serviceId) && Objects.equals(this.serviceName, ineligibleRate.serviceName) && Objects.equals(this.carrierName, ineligibleRate.carrierName) && Objects.equals(this.carrierId, ineligibleRate.carrierId) && Objects.equals(this.ineligibilityReasons, ineligibleRate.ineligibilityReasons);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.serviceName, this.carrierName, this.carrierId, this.ineligibilityReasons);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IneligibleRate {\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    carrierId: ").append(this.toIndentedString(this.carrierId)).append("\n");
        sb.append("    ineligibilityReasons: ").append(this.toIndentedString(this.ineligibilityReasons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

