/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum DocumentFormat {
    PDF("PDF"),
    PNG("PNG"),
    ZPL("ZPL");

    private String value;

    private DocumentFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentFormat fromValue(String input) {
        for (DocumentFormat b : DocumentFormat.values()) {
            if (!b.value.equals(input)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<DocumentFormat> {
        public void write(JsonWriter jsonWriter, DocumentFormat enumeration) throws IOException {
            jsonWriter.value(String.valueOf(enumeration.getValue()));
        }

        public DocumentFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return DocumentFormat.fromValue(value);
        }
    }
}

