/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Details related to any dangerous goods/items that are being shipped.")
public class DangerousGoodsDetails {
    @SerializedName(value="unitedNationsRegulatoryId")
    private String unitedNationsRegulatoryId = null;
    @SerializedName(value="transportationRegulatoryClass")
    private String transportationRegulatoryClass = null;
    @SerializedName(value="packingGroup")
    private PackingGroupEnum packingGroup = null;
    @SerializedName(value="packingInstruction")
    private PackingInstructionEnum packingInstruction = null;

    public DangerousGoodsDetails unitedNationsRegulatoryId(String unitedNationsRegulatoryId) {
        this.unitedNationsRegulatoryId = unitedNationsRegulatoryId;
        return this;
    }

    @Schema(description="The specific UNID of the item being shipped.")
    public String getUnitedNationsRegulatoryId() {
        return this.unitedNationsRegulatoryId;
    }

    public void setUnitedNationsRegulatoryId(String unitedNationsRegulatoryId) {
        this.unitedNationsRegulatoryId = unitedNationsRegulatoryId;
    }

    public DangerousGoodsDetails transportationRegulatoryClass(String transportationRegulatoryClass) {
        this.transportationRegulatoryClass = transportationRegulatoryClass;
        return this;
    }

    @Schema(description="The specific regulatory class  of the item being shipped.")
    public String getTransportationRegulatoryClass() {
        return this.transportationRegulatoryClass;
    }

    public void setTransportationRegulatoryClass(String transportationRegulatoryClass) {
        this.transportationRegulatoryClass = transportationRegulatoryClass;
    }

    public DangerousGoodsDetails packingGroup(PackingGroupEnum packingGroup) {
        this.packingGroup = packingGroup;
        return this;
    }

    @Schema(description="The specific packaging group of the item being shipped.")
    public PackingGroupEnum getPackingGroup() {
        return this.packingGroup;
    }

    public void setPackingGroup(PackingGroupEnum packingGroup) {
        this.packingGroup = packingGroup;
    }

    public DangerousGoodsDetails packingInstruction(PackingInstructionEnum packingInstruction) {
        this.packingInstruction = packingInstruction;
        return this;
    }

    @Schema(description="The specific packing instruction of the item being shipped.")
    public PackingInstructionEnum getPackingInstruction() {
        return this.packingInstruction;
    }

    public void setPackingInstruction(PackingInstructionEnum packingInstruction) {
        this.packingInstruction = packingInstruction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DangerousGoodsDetails dangerousGoodsDetails = (DangerousGoodsDetails)o;
        return Objects.equals(this.unitedNationsRegulatoryId, dangerousGoodsDetails.unitedNationsRegulatoryId) && Objects.equals(this.transportationRegulatoryClass, dangerousGoodsDetails.transportationRegulatoryClass) && Objects.equals((Object)this.packingGroup, (Object)dangerousGoodsDetails.packingGroup) && Objects.equals((Object)this.packingInstruction, (Object)dangerousGoodsDetails.packingInstruction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitedNationsRegulatoryId, this.transportationRegulatoryClass, this.packingGroup, this.packingInstruction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DangerousGoodsDetails {\n");
        sb.append("    unitedNationsRegulatoryId: ").append(this.toIndentedString(this.unitedNationsRegulatoryId)).append("\n");
        sb.append("    transportationRegulatoryClass: ").append(this.toIndentedString(this.transportationRegulatoryClass)).append("\n");
        sb.append("    packingGroup: ").append(this.toIndentedString((Object)this.packingGroup)).append("\n");
        sb.append("    packingInstruction: ").append(this.toIndentedString((Object)this.packingInstruction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PackingInstructionEnum {
        PI965_SECTION_IA("PI965_SECTION_IA"),
        PI965_SECTION_IB("PI965_SECTION_IB"),
        PI965_SECTION_II("PI965_SECTION_II"),
        PI966_SECTION_I("PI966_SECTION_I"),
        PI966_SECTION_II("PI966_SECTION_II"),
        PI967_SECTION_I("PI967_SECTION_I"),
        PI967_SECTION_II("PI967_SECTION_II"),
        PI968_SECTION_IA("PI968_SECTION_IA"),
        PI968_SECTION_IB("PI968_SECTION_IB"),
        PI969_SECTION_I("PI969_SECTION_I"),
        PI969_SECTION_II("PI969_SECTION_II"),
        PI970_SECTION_I("PI970_SECTION_I"),
        PI970_SECTION_II("PI970_SECTION_II");

        private String value;

        private PackingInstructionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PackingInstructionEnum fromValue(String input) {
            for (PackingInstructionEnum b : PackingInstructionEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PackingInstructionEnum> {
            public void write(JsonWriter jsonWriter, PackingInstructionEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PackingInstructionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PackingInstructionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PackingGroupEnum {
        I("I"),
        II("II"),
        III("III");

        private String value;

        private PackingGroupEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PackingGroupEnum fromValue(String input) {
            for (PackingGroupEnum b : PackingGroupEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PackingGroupEnum> {
            public void write(JsonWriter jsonWriter, PackingGroupEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PackingGroupEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PackingGroupEnum.fromValue(value);
            }
        }
    }
}

