/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.Currency;

@Schema(description="The type and amount of a charge applied on a package.")
public class ChargeComponent {
    @SerializedName(value="amount")
    private Currency amount = null;
    @SerializedName(value="chargeType")
    private ChargeTypeEnum chargeType = null;

    public ChargeComponent amount(Currency amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="")
    public Currency getAmount() {
        return this.amount;
    }

    public void setAmount(Currency amount) {
        this.amount = amount;
    }

    public ChargeComponent chargeType(ChargeTypeEnum chargeType) {
        this.chargeType = chargeType;
        return this;
    }

    @Schema(description="The type of charge.")
    public ChargeTypeEnum getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(ChargeTypeEnum chargeType) {
        this.chargeType = chargeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeComponent chargeComponent = (ChargeComponent)o;
        return Objects.equals(this.amount, chargeComponent.amount) && Objects.equals((Object)this.chargeType, (Object)chargeComponent.chargeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.chargeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeComponent {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    chargeType: ").append(this.toIndentedString((Object)this.chargeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChargeTypeEnum {
        TAX("TAX"),
        DISCOUNT("DISCOUNT");

        private String value;

        private ChargeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChargeTypeEnum fromValue(String input) {
            for (ChargeTypeEnum b : ChargeTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ChargeTypeEnum> {
            public void write(JsonWriter jsonWriter, ChargeTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ChargeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChargeTypeEnum.fromValue(value);
            }
        }
    }
}

