/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.Geocode;

@Schema(description="The address.")
public class Address {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="addressLine1")
    private String addressLine1 = null;
    @SerializedName(value="addressLine2")
    private String addressLine2 = null;
    @SerializedName(value="addressLine3")
    private String addressLine3 = null;
    @SerializedName(value="companyName")
    private String companyName = null;
    @SerializedName(value="stateOrRegion")
    private String stateOrRegion = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="postalCode")
    private String postalCode = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;
    @SerializedName(value="geocode")
    private Geocode geocode = null;

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The name of the person, business or institution at the address.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @Schema(required=true, description="The first line of the address.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Schema(description="Additional address information, if required.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address addressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
        return this;
    }

    @Schema(description="Additional address information, if required.")
    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public Address companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Schema(description="The name of the business or institution associated with the address.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Address stateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
        return this;
    }

    @Schema(required=true, description="")
    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public void setStateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Schema(required=true, description="")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(required=true, description="")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(required=true, description="")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The email address of the contact associated with the address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Address phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="The phone number of the person, business or institution located at that address, including the country calling code.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Address geocode(Geocode geocode) {
        this.geocode = geocode;
        return this;
    }

    @Schema(description="")
    public Geocode getGeocode() {
        return this.geocode;
    }

    public void setGeocode(Geocode geocode) {
        this.geocode = geocode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.name, address.name) && Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.addressLine3, address.addressLine3) && Objects.equals(this.companyName, address.companyName) && Objects.equals(this.stateOrRegion, address.stateOrRegion) && Objects.equals(this.city, address.city) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.email, address.email) && Objects.equals(this.phoneNumber, address.phoneNumber) && Objects.equals(this.geocode, address.geocode);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.addressLine1, this.addressLine2, this.addressLine3, this.companyName, this.stateOrRegion, this.city, this.countryCode, this.postalCode, this.email, this.phoneNumber, this.geocode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    stateOrRegion: ").append(this.toIndentedString(this.stateOrRegion)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    geocode: ").append(this.toIndentedString(this.geocode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

