/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Defines the accessibility details of the access point.")
public class AccessibilityAttributes {
    @SerializedName(value="distance")
    private String distance = null;
    @SerializedName(value="driveTime")
    private Integer driveTime = null;

    public AccessibilityAttributes distance(String distance) {
        this.distance = distance;
        return this;
    }

    @Schema(description="The approximate distance of access point from input postalCode's centroid.")
    public String getDistance() {
        return this.distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public AccessibilityAttributes driveTime(Integer driveTime) {
        this.driveTime = driveTime;
        return this;
    }

    @Schema(description="The approximate (static) drive time from input postal code's centroid.")
    public Integer getDriveTime() {
        return this.driveTime;
    }

    public void setDriveTime(Integer driveTime) {
        this.driveTime = driveTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessibilityAttributes accessibilityAttributes = (AccessibilityAttributes)o;
        return Objects.equals(this.distance, accessibilityAttributes.distance) && Objects.equals(this.driveTime, accessibilityAttributes.driveTime);
    }

    public int hashCode() {
        return Objects.hash(this.distance, this.driveTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessibilityAttributes {\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    driveTime: ").append(this.toIndentedString(this.driveTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

