/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.AccessPointType;
import software.amazon.spapi.models.shipping.v2.AccessibilityAttributes;
import software.amazon.spapi.models.shipping.v2.Address;
import software.amazon.spapi.models.shipping.v2.DayOfWeekTimeMap;
import software.amazon.spapi.models.shipping.v2.ExceptionOperatingHours;

@Schema(description="Access point details")
public class AccessPoint {
    @SerializedName(value="accessPointId")
    private String accessPointId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="timezone")
    private String timezone = null;
    @SerializedName(value="type")
    private AccessPointType type = null;
    @SerializedName(value="accessibilityAttributes")
    private AccessibilityAttributes accessibilityAttributes = null;
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="exceptionOperatingHours")
    private List<ExceptionOperatingHours> exceptionOperatingHours = null;
    @SerializedName(value="assistanceType")
    private AssistanceTypeEnum assistanceType = null;
    @SerializedName(value="score")
    private String score = null;
    @SerializedName(value="standardOperatingHours")
    private DayOfWeekTimeMap standardOperatingHours = null;

    public AccessPoint accessPointId(String accessPointId) {
        this.accessPointId = accessPointId;
        return this;
    }

    @Schema(description="")
    public String getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(String accessPointId) {
        this.accessPointId = accessPointId;
    }

    public AccessPoint name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of entity (store/hub etc) where this access point is located")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessPoint timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Schema(description="Timezone of access point")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public AccessPoint type(AccessPointType type) {
        this.type = type;
        return this;
    }

    @Schema(description="")
    public AccessPointType getType() {
        return this.type;
    }

    public void setType(AccessPointType type) {
        this.type = type;
    }

    public AccessPoint accessibilityAttributes(AccessibilityAttributes accessibilityAttributes) {
        this.accessibilityAttributes = accessibilityAttributes;
        return this;
    }

    @Schema(description="")
    public AccessibilityAttributes getAccessibilityAttributes() {
        return this.accessibilityAttributes;
    }

    public void setAccessibilityAttributes(AccessibilityAttributes accessibilityAttributes) {
        this.accessibilityAttributes = accessibilityAttributes;
    }

    public AccessPoint address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public AccessPoint exceptionOperatingHours(List<ExceptionOperatingHours> exceptionOperatingHours) {
        this.exceptionOperatingHours = exceptionOperatingHours;
        return this;
    }

    public AccessPoint addExceptionOperatingHoursItem(ExceptionOperatingHours exceptionOperatingHoursItem) {
        if (this.exceptionOperatingHours == null) {
            this.exceptionOperatingHours = new ArrayList<ExceptionOperatingHours>();
        }
        this.exceptionOperatingHours.add(exceptionOperatingHoursItem);
        return this;
    }

    @Schema(description="Exception operating hours for Access Point")
    public List<ExceptionOperatingHours> getExceptionOperatingHours() {
        return this.exceptionOperatingHours;
    }

    public void setExceptionOperatingHours(List<ExceptionOperatingHours> exceptionOperatingHours) {
        this.exceptionOperatingHours = exceptionOperatingHours;
    }

    public AccessPoint assistanceType(AssistanceTypeEnum assistanceType) {
        this.assistanceType = assistanceType;
        return this;
    }

    @Schema(description="Assistance type enum for Access point i.e. STAFF_ASSISTED or SELF_ASSISTED")
    public AssistanceTypeEnum getAssistanceType() {
        return this.assistanceType;
    }

    public void setAssistanceType(AssistanceTypeEnum assistanceType) {
        this.assistanceType = assistanceType;
    }

    public AccessPoint score(String score) {
        this.score = score;
        return this;
    }

    @Schema(description="The score of access point, based on proximity to postal code and sorting preference. This can be used to sort access point results on shipper's end.")
    public String getScore() {
        return this.score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public AccessPoint standardOperatingHours(DayOfWeekTimeMap standardOperatingHours) {
        this.standardOperatingHours = standardOperatingHours;
        return this;
    }

    @Schema(description="")
    public DayOfWeekTimeMap getStandardOperatingHours() {
        return this.standardOperatingHours;
    }

    public void setStandardOperatingHours(DayOfWeekTimeMap standardOperatingHours) {
        this.standardOperatingHours = standardOperatingHours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessPoint accessPoint = (AccessPoint)o;
        return Objects.equals(this.accessPointId, accessPoint.accessPointId) && Objects.equals(this.name, accessPoint.name) && Objects.equals(this.timezone, accessPoint.timezone) && Objects.equals((Object)this.type, (Object)accessPoint.type) && Objects.equals(this.accessibilityAttributes, accessPoint.accessibilityAttributes) && Objects.equals(this.address, accessPoint.address) && Objects.equals(this.exceptionOperatingHours, accessPoint.exceptionOperatingHours) && Objects.equals((Object)this.assistanceType, (Object)accessPoint.assistanceType) && Objects.equals(this.score, accessPoint.score) && Objects.equals(this.standardOperatingHours, accessPoint.standardOperatingHours);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessPointId, this.name, this.timezone, this.type, this.accessibilityAttributes, this.address, this.exceptionOperatingHours, this.assistanceType, this.score, this.standardOperatingHours});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessPoint {\n");
        sb.append("    accessPointId: ").append(this.toIndentedString(this.accessPointId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    accessibilityAttributes: ").append(this.toIndentedString(this.accessibilityAttributes)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    exceptionOperatingHours: ").append(this.toIndentedString(this.exceptionOperatingHours)).append("\n");
        sb.append("    assistanceType: ").append(this.toIndentedString((Object)this.assistanceType)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    standardOperatingHours: ").append(this.toIndentedString(this.standardOperatingHours)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssistanceTypeEnum {
        STAFF_ASSISTED("STAFF_ASSISTED"),
        SELF_ASSISTED("SELF_ASSISTED");

        private String value;

        private AssistanceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssistanceTypeEnum fromValue(String input) {
            for (AssistanceTypeEnum b : AssistanceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AssistanceTypeEnum> {
            public void write(JsonWriter jsonWriter, AssistanceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AssistanceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssistanceTypeEnum.fromValue(value);
            }
        }
    }
}

