/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Input for to be uploaded document.")
public class ServiceUploadDocument {
    @SerializedName(value="contentType")
    private ContentTypeEnum contentType = null;
    @SerializedName(value="contentLength")
    private BigDecimal contentLength = null;
    @SerializedName(value="contentMD5")
    private String contentMD5 = null;

    public ServiceUploadDocument contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(required=true, description="The content type of the to-be-uploaded file")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public ServiceUploadDocument contentLength(BigDecimal contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @Schema(required=true, description="The content length of the to-be-uploaded file")
    public BigDecimal getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(BigDecimal contentLength) {
        this.contentLength = contentLength;
    }

    public ServiceUploadDocument contentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    @Schema(description="An MD5 hash of the content to be submitted to the upload destination. This value is used to determine if the data has been corrupted or tampered with during transit.")
    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceUploadDocument serviceUploadDocument = (ServiceUploadDocument)o;
        return Objects.equals((Object)this.contentType, (Object)serviceUploadDocument.contentType) && Objects.equals(this.contentLength, serviceUploadDocument.contentLength) && Objects.equals(this.contentMD5, serviceUploadDocument.contentMD5);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.contentLength, this.contentMD5});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceUploadDocument {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    contentMD5: ").append(this.toIndentedString(this.contentMD5)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentTypeEnum {
        TIFF("TIFF"),
        JPG("JPG"),
        PNG("PNG"),
        JPEG("JPEG"),
        GIF("GIF"),
        PDF("PDF");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentTypeEnum fromValue(String input) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContentTypeEnum> {
            public void write(JsonWriter jsonWriter, ContentTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ContentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentTypeEnum.fromValue(value);
            }
        }
    }
}

