/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The scope of work for the order.")
public class ScopeOfWork {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="requiredSkills")
    private List<String> requiredSkills = null;

    public ScopeOfWork asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of the service job.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ScopeOfWork title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the service job.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScopeOfWork quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The number of service jobs.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ScopeOfWork requiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
        return this;
    }

    public ScopeOfWork addRequiredSkillsItem(String requiredSkillsItem) {
        if (this.requiredSkills == null) {
            this.requiredSkills = new ArrayList<String>();
        }
        this.requiredSkills.add(requiredSkillsItem);
        return this;
    }

    @Schema(description="A list of skills required to perform the job.")
    public List<String> getRequiredSkills() {
        return this.requiredSkills;
    }

    public void setRequiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeOfWork scopeOfWork = (ScopeOfWork)o;
        return Objects.equals(this.asin, scopeOfWork.asin) && Objects.equals(this.title, scopeOfWork.title) && Objects.equals(this.quantity, scopeOfWork.quantity) && Objects.equals(this.requiredSkills, scopeOfWork.requiredSkills);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.title, this.quantity, this.requiredSkills);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScopeOfWork {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    requiredSkills: ").append(this.toIndentedString(this.requiredSkills)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

