/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.RangeCapacity;

@Schema(description="Response schema for the `getRangeSlotCapacity` operation.")
public class RangeSlotCapacity {
    @SerializedName(value="resourceId")
    private String resourceId = null;
    @SerializedName(value="capacities")
    private List<RangeCapacity> capacities = null;
    @SerializedName(value="nextPageToken")
    private String nextPageToken = null;

    public RangeSlotCapacity resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Schema(description="Resource Identifier.")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public RangeSlotCapacity capacities(List<RangeCapacity> capacities) {
        this.capacities = capacities;
        return this;
    }

    public RangeSlotCapacity addCapacitiesItem(RangeCapacity capacitiesItem) {
        if (this.capacities == null) {
            this.capacities = new ArrayList<RangeCapacity>();
        }
        this.capacities.add(capacitiesItem);
        return this;
    }

    @Schema(description="Array of range capacities where each entry is for a specific capacity type.")
    public List<RangeCapacity> getCapacities() {
        return this.capacities;
    }

    public void setCapacities(List<RangeCapacity> capacities) {
        this.capacities = capacities;
    }

    public RangeSlotCapacity nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Schema(description="Next page token, if there are more pages.")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeSlotCapacity rangeSlotCapacity = (RangeSlotCapacity)o;
        return Objects.equals(this.resourceId, rangeSlotCapacity.resourceId) && Objects.equals(this.capacities, rangeSlotCapacity.capacities) && Objects.equals(this.nextPageToken, rangeSlotCapacity.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.capacities, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RangeSlotCapacity {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    capacities: ").append(this.toIndentedString(this.capacities)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

