/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.ServiceJob;

@Schema(description="The payload for the `getServiceJobs` operation.")
public class JobListing {
    @SerializedName(value="totalResultSize")
    private Integer totalResultSize = null;
    @SerializedName(value="nextPageToken")
    private String nextPageToken = null;
    @SerializedName(value="previousPageToken")
    private String previousPageToken = null;
    @SerializedName(value="jobs")
    private List<ServiceJob> jobs = null;

    public JobListing totalResultSize(Integer totalResultSize) {
        this.totalResultSize = totalResultSize;
        return this;
    }

    @Schema(description="Total result size of the query result.")
    public Integer getTotalResultSize() {
        return this.totalResultSize;
    }

    public void setTotalResultSize(Integer totalResultSize) {
        this.totalResultSize = totalResultSize;
    }

    public JobListing nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Schema(description="A generated string used to pass information to your next request. If `nextPageToken` is returned, pass the value of `nextPageToken` to the `pageToken` to get next results.")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public JobListing previousPageToken(String previousPageToken) {
        this.previousPageToken = previousPageToken;
        return this;
    }

    @Schema(description="A generated string used to pass information to your next request. If `previousPageToken` is returned, pass the value of `previousPageToken` to the `pageToken` to get previous page results.")
    public String getPreviousPageToken() {
        return this.previousPageToken;
    }

    public void setPreviousPageToken(String previousPageToken) {
        this.previousPageToken = previousPageToken;
    }

    public JobListing jobs(List<ServiceJob> jobs) {
        this.jobs = jobs;
        return this;
    }

    public JobListing addJobsItem(ServiceJob jobsItem) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<ServiceJob>();
        }
        this.jobs.add(jobsItem);
        return this;
    }

    @Schema(description="List of job details for the given input.")
    public List<ServiceJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<ServiceJob> jobs) {
        this.jobs = jobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobListing jobListing = (JobListing)o;
        return Objects.equals(this.totalResultSize, jobListing.totalResultSize) && Objects.equals(this.nextPageToken, jobListing.nextPageToken) && Objects.equals(this.previousPageToken, jobListing.previousPageToken) && Objects.equals(this.jobs, jobListing.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.totalResultSize, this.nextPageToken, this.previousPageToken, this.jobs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobListing {\n");
        sb.append("    totalResultSize: ").append(this.toIndentedString(this.totalResultSize)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    previousPageToken: ").append(this.toIndentedString(this.previousPageToken)).append("\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

