/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="A time window along with associated capacity in which the service can be performed.")
public class AppointmentSlot {
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;
    @SerializedName(value="capacity")
    private Integer capacity = null;

    public AppointmentSlot startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="Time window start time in ISO 8601 format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public AppointmentSlot endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(description="Time window end time in ISO 8601 format.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public AppointmentSlot capacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @Schema(description="Number of resources for which a slot can be reserved.")
    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppointmentSlot appointmentSlot = (AppointmentSlot)o;
        return Objects.equals(this.startTime, appointmentSlot.startTime) && Objects.equals(this.endTime, appointmentSlot.endTime) && Objects.equals(this.capacity, appointmentSlot.capacity);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppointmentSlot {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

