/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.AppointmentTime;
import software.amazon.spapi.models.services.v1.Poa;
import software.amazon.spapi.models.services.v1.Technician;

@Schema(description="The details of an appointment.")
public class Appointment {
    @SerializedName(value="appointmentId")
    private String appointmentId = null;
    @SerializedName(value="appointmentStatus")
    private AppointmentStatusEnum appointmentStatus = null;
    @SerializedName(value="appointmentTime")
    private AppointmentTime appointmentTime = null;
    @SerializedName(value="assignedTechnicians")
    private List<Technician> assignedTechnicians = null;
    @SerializedName(value="rescheduledAppointmentId")
    private String rescheduledAppointmentId = null;
    @SerializedName(value="poa")
    private Poa poa = null;

    public Appointment appointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
        return this;
    }

    @Schema(description="")
    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public Appointment appointmentStatus(AppointmentStatusEnum appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
        return this;
    }

    @Schema(description="The status of the appointment.")
    public AppointmentStatusEnum getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public void setAppointmentStatus(AppointmentStatusEnum appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
    }

    public Appointment appointmentTime(AppointmentTime appointmentTime) {
        this.appointmentTime = appointmentTime;
        return this;
    }

    @Schema(description="")
    public AppointmentTime getAppointmentTime() {
        return this.appointmentTime;
    }

    public void setAppointmentTime(AppointmentTime appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    public Appointment assignedTechnicians(List<Technician> assignedTechnicians) {
        this.assignedTechnicians = assignedTechnicians;
        return this;
    }

    public Appointment addAssignedTechniciansItem(Technician assignedTechniciansItem) {
        if (this.assignedTechnicians == null) {
            this.assignedTechnicians = new ArrayList<Technician>();
        }
        this.assignedTechnicians.add(assignedTechniciansItem);
        return this;
    }

    @Schema(description="A list of technicians assigned to the service job.")
    public List<Technician> getAssignedTechnicians() {
        return this.assignedTechnicians;
    }

    public void setAssignedTechnicians(List<Technician> assignedTechnicians) {
        this.assignedTechnicians = assignedTechnicians;
    }

    public Appointment rescheduledAppointmentId(String rescheduledAppointmentId) {
        this.rescheduledAppointmentId = rescheduledAppointmentId;
        return this;
    }

    @Schema(description="")
    public String getRescheduledAppointmentId() {
        return this.rescheduledAppointmentId;
    }

    public void setRescheduledAppointmentId(String rescheduledAppointmentId) {
        this.rescheduledAppointmentId = rescheduledAppointmentId;
    }

    public Appointment poa(Poa poa) {
        this.poa = poa;
        return this;
    }

    @Schema(description="")
    public Poa getPoa() {
        return this.poa;
    }

    public void setPoa(Poa poa) {
        this.poa = poa;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Appointment appointment = (Appointment)o;
        return Objects.equals(this.appointmentId, appointment.appointmentId) && Objects.equals((Object)this.appointmentStatus, (Object)appointment.appointmentStatus) && Objects.equals(this.appointmentTime, appointment.appointmentTime) && Objects.equals(this.assignedTechnicians, appointment.assignedTechnicians) && Objects.equals(this.rescheduledAppointmentId, appointment.rescheduledAppointmentId) && Objects.equals(this.poa, appointment.poa);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appointmentId, this.appointmentStatus, this.appointmentTime, this.assignedTechnicians, this.rescheduledAppointmentId, this.poa});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Appointment {\n");
        sb.append("    appointmentId: ").append(this.toIndentedString(this.appointmentId)).append("\n");
        sb.append("    appointmentStatus: ").append(this.toIndentedString((Object)this.appointmentStatus)).append("\n");
        sb.append("    appointmentTime: ").append(this.toIndentedString(this.appointmentTime)).append("\n");
        sb.append("    assignedTechnicians: ").append(this.toIndentedString(this.assignedTechnicians)).append("\n");
        sb.append("    rescheduledAppointmentId: ").append(this.toIndentedString(this.rescheduledAppointmentId)).append("\n");
        sb.append("    poa: ").append(this.toIndentedString(this.poa)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AppointmentStatusEnum {
        ACTIVE("ACTIVE"),
        CANCELLED("CANCELLED"),
        COMPLETED("COMPLETED");

        private String value;

        private AppointmentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AppointmentStatusEnum fromValue(String input) {
            for (AppointmentStatusEnum b : AppointmentStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AppointmentStatusEnum> {
            public void write(JsonWriter jsonWriter, AppointmentStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AppointmentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AppointmentStatusEnum.fromValue(value);
            }
        }
    }
}

