/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferSchedule;

@Schema(description="Struct that holds collection of transfer schedules.")
public class TransferScheduleListing {
    @SerializedName(value="nextPageToken")
    private String nextPageToken = null;
    @SerializedName(value="transferSchedules")
    private List<TransferSchedule> transferSchedules = new ArrayList<TransferSchedule>();

    public TransferScheduleListing nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Schema(example="3493805734095308457308475", description="If present, use this pagination token to retrieve the next page of supply sources, if not provided the API will return same response. The field will only be provided when the list is greater than 100.")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public TransferScheduleListing transferSchedules(List<TransferSchedule> transferSchedules) {
        this.transferSchedules = transferSchedules;
        return this;
    }

    public TransferScheduleListing addTransferSchedulesItem(TransferSchedule transferSchedulesItem) {
        this.transferSchedules.add(transferSchedulesItem);
        return this;
    }

    @Schema(required=true, description="Collection that holds list of Transfer Schedules ")
    public List<TransferSchedule> getTransferSchedules() {
        return this.transferSchedules;
    }

    public void setTransferSchedules(List<TransferSchedule> transferSchedules) {
        this.transferSchedules = transferSchedules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferScheduleListing transferScheduleListing = (TransferScheduleListing)o;
        return Objects.equals(this.nextPageToken, transferScheduleListing.nextPageToken) && Objects.equals(this.transferSchedules, transferScheduleListing.transferSchedules);
    }

    public int hashCode() {
        return Objects.hash(this.nextPageToken, this.transferSchedules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferScheduleListing {\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    transferSchedules: ").append(this.toIndentedString(this.transferSchedules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

