/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Transaction;

@Schema(description="Struct that holds collection of transactions.")
public class TransactionListing {
    @SerializedName(value="nextPageToken")
    private String nextPageToken = null;
    @SerializedName(value="transactions")
    private List<Transaction> transactions = new ArrayList<Transaction>();

    public TransactionListing nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Schema(example="3493805734095308457308475", description="If present, use this pagination token to retrieve the next page of supply sources, if not provided the API will return same response. The field will only be provided when the list is greater than 100.")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public TransactionListing transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public TransactionListing addTransactionsItem(Transaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @Schema(required=true, description="Collection that holds Transaction ")
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionListing transactionListing = (TransactionListing)o;
        return Objects.equals(this.nextPageToken, transactionListing.nextPageToken) && Objects.equals(this.transactions, transactionListing.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.nextPageToken, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionListing {\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

