/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Address for bank account verification of the Payee. For example, this can be a person or business mailing address ")
public class AccountHolderAddress {
    @SerializedName(value="addressLine1")
    private String addressLine1 = null;
    @SerializedName(value="addressLine2")
    private String addressLine2 = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="postalCode")
    private String postalCode = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;

    public AccountHolderAddress addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @Schema(example="678 JFK Street", required=true, description="Address Line 1 of the public address ")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public AccountHolderAddress addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Schema(example="Unit 415", description="Address Line 2 of the public address ")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public AccountHolderAddress city(String city) {
        this.city = city;
        return this;
    }

    @Schema(example="Seattle", required=true, description="City name of the public address ")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public AccountHolderAddress state(String state) {
        this.state = state;
        return this;
    }

    @Schema(example="WA", required=true, description="State name of the public address. This is the state or region for China-based addresses.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AccountHolderAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(example="98109", required=true, description="Postal code of the public address ")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AccountHolderAddress country(String country) {
        this.country = country;
        return this;
    }

    @Schema(example="United States", description="Country name of the public address ")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public AccountHolderAddress countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(example="US", required=true, description="The two digit country code, in ISO 3166 format. ")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderAddress accountHolderAddress = (AccountHolderAddress)o;
        return Objects.equals(this.addressLine1, accountHolderAddress.addressLine1) && Objects.equals(this.addressLine2, accountHolderAddress.addressLine2) && Objects.equals(this.city, accountHolderAddress.city) && Objects.equals(this.state, accountHolderAddress.state) && Objects.equals(this.postalCode, accountHolderAddress.postalCode) && Objects.equals(this.country, accountHolderAddress.country) && Objects.equals(this.countryCode, accountHolderAddress.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.city, this.state, this.postalCode, this.country, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderAddress {\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

