/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.replenishment.v2022_11_07;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;
import software.amazon.spapi.models.replenishment.v2022_11_07.TimeInterval;

@Schema(description="An object which contains metric data for a selling partner.")
public class GetSellingPartnerMetricsResponseMetric {
    @SerializedName(value="notDeliveredDueToOOS")
    private Double notDeliveredDueToOOS = null;
    @SerializedName(value="totalSubscriptionsRevenue")
    private Double totalSubscriptionsRevenue = null;
    @SerializedName(value="shippedSubscriptionUnits")
    private BigDecimal shippedSubscriptionUnits = null;
    @SerializedName(value="activeSubscriptions")
    private BigDecimal activeSubscriptions = null;
    @SerializedName(value="subscriberAverageRevenue")
    private Double subscriberAverageRevenue = null;
    @SerializedName(value="nonSubscriberAverageRevenue")
    private Double nonSubscriberAverageRevenue = null;
    @SerializedName(value="lostRevenueDueToOOS")
    private Double lostRevenueDueToOOS = null;
    @SerializedName(value="subscriberAverageReorders")
    private Double subscriberAverageReorders = null;
    @SerializedName(value="nonSubscriberAverageReorders")
    private Double nonSubscriberAverageReorders = null;
    @SerializedName(value="couponsRevenuePenetration")
    private Double couponsRevenuePenetration = null;
    @SerializedName(value="revenueFromSubscriptionsWithMultipleDeliveries")
    private Double revenueFromSubscriptionsWithMultipleDeliveries = null;
    @SerializedName(value="revenueFromActiveSubscriptionsWithSingleDelivery")
    private Double revenueFromActiveSubscriptionsWithSingleDelivery = null;
    @SerializedName(value="revenueFromCancelledSubscriptionsAfterSingleDelivery")
    private Double revenueFromCancelledSubscriptionsAfterSingleDelivery = null;
    @SerializedName(value="subscriberRetentionFor30Days")
    private Double subscriberRetentionFor30Days = null;
    @SerializedName(value="subscriberRetentionFor90Days")
    private Double subscriberRetentionFor90Days = null;
    @SerializedName(value="revenuePenetrationFor0PercentSellerFunding")
    private Double revenuePenetrationFor0PercentSellerFunding = null;
    @SerializedName(value="revenuePenetrationFor5PercentSellerFunding")
    private Double revenuePenetrationFor5PercentSellerFunding = null;
    @SerializedName(value="revenuePenetrationFor10PercentSellerFunding")
    private Double revenuePenetrationFor10PercentSellerFunding = null;
    @SerializedName(value="revenuePenetrationFor5PlusPercentSellerFunding")
    private Double revenuePenetrationFor5PlusPercentSellerFunding = null;
    @SerializedName(value="shareOfCouponSubscriptions")
    private Double shareOfCouponSubscriptions = null;
    @SerializedName(value="timeInterval")
    private TimeInterval timeInterval = null;
    @SerializedName(value="currencyCode")
    private String currencyCode = null;

    public GetSellingPartnerMetricsResponseMetric notDeliveredDueToOOS(Double notDeliveredDueToOOS) {
        this.notDeliveredDueToOOS = notDeliveredDueToOOS;
        return this;
    }

    @Schema(description="The percentage of items that were not shipped out of the total shipped units over a period of time due to being out of stock. Applicable to PERFORMANCE timePeriodType.")
    public Double getNotDeliveredDueToOOS() {
        return this.notDeliveredDueToOOS;
    }

    public void setNotDeliveredDueToOOS(Double notDeliveredDueToOOS) {
        this.notDeliveredDueToOOS = notDeliveredDueToOOS;
    }

    public GetSellingPartnerMetricsResponseMetric totalSubscriptionsRevenue(Double totalSubscriptionsRevenue) {
        this.totalSubscriptionsRevenue = totalSubscriptionsRevenue;
        return this;
    }

    @Schema(description="The revenue generated from subscriptions over a period of time. Applicable for both the PERFORMANCE and FORECAST timePeriodType.")
    public Double getTotalSubscriptionsRevenue() {
        return this.totalSubscriptionsRevenue;
    }

    public void setTotalSubscriptionsRevenue(Double totalSubscriptionsRevenue) {
        this.totalSubscriptionsRevenue = totalSubscriptionsRevenue;
    }

    public GetSellingPartnerMetricsResponseMetric shippedSubscriptionUnits(BigDecimal shippedSubscriptionUnits) {
        this.shippedSubscriptionUnits = shippedSubscriptionUnits;
        return this;
    }

    @Schema(description="The number of units shipped to the subscribers over a period of time. Applicable for both the PERFORMANCE and FORECAST timePeriodType.")
    public BigDecimal getShippedSubscriptionUnits() {
        return this.shippedSubscriptionUnits;
    }

    public void setShippedSubscriptionUnits(BigDecimal shippedSubscriptionUnits) {
        this.shippedSubscriptionUnits = shippedSubscriptionUnits;
    }

    public GetSellingPartnerMetricsResponseMetric activeSubscriptions(BigDecimal activeSubscriptions) {
        this.activeSubscriptions = activeSubscriptions;
        return this;
    }

    @Schema(description="The number of active subscriptions present at the end of the period. Applicable to PERFORMANCE timePeriodType.")
    public BigDecimal getActiveSubscriptions() {
        return this.activeSubscriptions;
    }

    public void setActiveSubscriptions(BigDecimal activeSubscriptions) {
        this.activeSubscriptions = activeSubscriptions;
    }

    public GetSellingPartnerMetricsResponseMetric subscriberAverageRevenue(Double subscriberAverageRevenue) {
        this.subscriberAverageRevenue = subscriberAverageRevenue;
        return this;
    }

    @Schema(description="The average revenue per subscriber of the program over a period of past 12 months for sellers and 6 months for vendors. Applicable to PERFORMANCE timePeriodType.")
    public Double getSubscriberAverageRevenue() {
        return this.subscriberAverageRevenue;
    }

    public void setSubscriberAverageRevenue(Double subscriberAverageRevenue) {
        this.subscriberAverageRevenue = subscriberAverageRevenue;
    }

    public GetSellingPartnerMetricsResponseMetric nonSubscriberAverageRevenue(Double nonSubscriberAverageRevenue) {
        this.nonSubscriberAverageRevenue = nonSubscriberAverageRevenue;
        return this;
    }

    @Schema(description="The average revenue per non-subscriber of the program over a period of past 12 months for sellers and 6 months for vendors. Applicable to PERFORMANCE timePeriodType.")
    public Double getNonSubscriberAverageRevenue() {
        return this.nonSubscriberAverageRevenue;
    }

    public void setNonSubscriberAverageRevenue(Double nonSubscriberAverageRevenue) {
        this.nonSubscriberAverageRevenue = nonSubscriberAverageRevenue;
    }

    public GetSellingPartnerMetricsResponseMetric lostRevenueDueToOOS(Double lostRevenueDueToOOS) {
        this.lostRevenueDueToOOS = lostRevenueDueToOOS;
        return this;
    }

    @Schema(description="The revenue that would have been generated had there not been out of stock. Applicable to PERFORMANCE timePeriodType.")
    public Double getLostRevenueDueToOOS() {
        return this.lostRevenueDueToOOS;
    }

    public void setLostRevenueDueToOOS(Double lostRevenueDueToOOS) {
        this.lostRevenueDueToOOS = lostRevenueDueToOOS;
    }

    public GetSellingPartnerMetricsResponseMetric subscriberAverageReorders(Double subscriberAverageReorders) {
        this.subscriberAverageReorders = subscriberAverageReorders;
        return this;
    }

    @Schema(description="The average reorders per subscriber of the program over a period of 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getSubscriberAverageReorders() {
        return this.subscriberAverageReorders;
    }

    public void setSubscriberAverageReorders(Double subscriberAverageReorders) {
        this.subscriberAverageReorders = subscriberAverageReorders;
    }

    public GetSellingPartnerMetricsResponseMetric nonSubscriberAverageReorders(Double nonSubscriberAverageReorders) {
        this.nonSubscriberAverageReorders = nonSubscriberAverageReorders;
        return this;
    }

    @Schema(description="The average reorders per non-subscriber of the program over a period of past 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getNonSubscriberAverageReorders() {
        return this.nonSubscriberAverageReorders;
    }

    public void setNonSubscriberAverageReorders(Double nonSubscriberAverageReorders) {
        this.nonSubscriberAverageReorders = nonSubscriberAverageReorders;
    }

    public GetSellingPartnerMetricsResponseMetric couponsRevenuePenetration(Double couponsRevenuePenetration) {
        this.couponsRevenuePenetration = couponsRevenuePenetration;
        return this;
    }

    @Schema(description="The percentage of revenue from ASINs with coupons out of total revenue from all ASINs. Applicable to PERFORMANCE timePeriodType.")
    public Double getCouponsRevenuePenetration() {
        return this.couponsRevenuePenetration;
    }

    public void setCouponsRevenuePenetration(Double couponsRevenuePenetration) {
        this.couponsRevenuePenetration = couponsRevenuePenetration;
    }

    public GetSellingPartnerMetricsResponseMetric revenueFromSubscriptionsWithMultipleDeliveries(Double revenueFromSubscriptionsWithMultipleDeliveries) {
        this.revenueFromSubscriptionsWithMultipleDeliveries = revenueFromSubscriptionsWithMultipleDeliveries;
        return this;
    }

    @Schema(description="The subscription revenue generated from subscriptions with over two deliveries over the past 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenueFromSubscriptionsWithMultipleDeliveries() {
        return this.revenueFromSubscriptionsWithMultipleDeliveries;
    }

    public void setRevenueFromSubscriptionsWithMultipleDeliveries(Double revenueFromSubscriptionsWithMultipleDeliveries) {
        this.revenueFromSubscriptionsWithMultipleDeliveries = revenueFromSubscriptionsWithMultipleDeliveries;
    }

    public GetSellingPartnerMetricsResponseMetric revenueFromActiveSubscriptionsWithSingleDelivery(Double revenueFromActiveSubscriptionsWithSingleDelivery) {
        this.revenueFromActiveSubscriptionsWithSingleDelivery = revenueFromActiveSubscriptionsWithSingleDelivery;
        return this;
    }

    @Schema(description="The subscription revenue generated from active subscriptions with one delivery over the past 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenueFromActiveSubscriptionsWithSingleDelivery() {
        return this.revenueFromActiveSubscriptionsWithSingleDelivery;
    }

    public void setRevenueFromActiveSubscriptionsWithSingleDelivery(Double revenueFromActiveSubscriptionsWithSingleDelivery) {
        this.revenueFromActiveSubscriptionsWithSingleDelivery = revenueFromActiveSubscriptionsWithSingleDelivery;
    }

    public GetSellingPartnerMetricsResponseMetric revenueFromCancelledSubscriptionsAfterSingleDelivery(Double revenueFromCancelledSubscriptionsAfterSingleDelivery) {
        this.revenueFromCancelledSubscriptionsAfterSingleDelivery = revenueFromCancelledSubscriptionsAfterSingleDelivery;
        return this;
    }

    @Schema(description="The subscription revenue generated from subscriptions which are cancelled after one delivery over the past 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenueFromCancelledSubscriptionsAfterSingleDelivery() {
        return this.revenueFromCancelledSubscriptionsAfterSingleDelivery;
    }

    public void setRevenueFromCancelledSubscriptionsAfterSingleDelivery(Double revenueFromCancelledSubscriptionsAfterSingleDelivery) {
        this.revenueFromCancelledSubscriptionsAfterSingleDelivery = revenueFromCancelledSubscriptionsAfterSingleDelivery;
    }

    public GetSellingPartnerMetricsResponseMetric subscriberRetentionFor30Days(Double subscriberRetentionFor30Days) {
        this.subscriberRetentionFor30Days = subscriberRetentionFor30Days;
        return this;
    }

    @Schema(description="The percentage of subscriptions retained after 30 days of subscription creation. Applicable to PERFORMANCE timePeriodType.")
    public Double getSubscriberRetentionFor30Days() {
        return this.subscriberRetentionFor30Days;
    }

    public void setSubscriberRetentionFor30Days(Double subscriberRetentionFor30Days) {
        this.subscriberRetentionFor30Days = subscriberRetentionFor30Days;
    }

    public GetSellingPartnerMetricsResponseMetric subscriberRetentionFor90Days(Double subscriberRetentionFor90Days) {
        this.subscriberRetentionFor90Days = subscriberRetentionFor90Days;
        return this;
    }

    @Schema(description="The percentage of subscriptions retained after 90 days of subscription creation. Applicable to PERFORMANCE timePeriodType.")
    public Double getSubscriberRetentionFor90Days() {
        return this.subscriberRetentionFor90Days;
    }

    public void setSubscriberRetentionFor90Days(Double subscriberRetentionFor90Days) {
        this.subscriberRetentionFor90Days = subscriberRetentionFor90Days;
    }

    public GetSellingPartnerMetricsResponseMetric revenuePenetrationFor0PercentSellerFunding(Double revenuePenetrationFor0PercentSellerFunding) {
        this.revenuePenetrationFor0PercentSellerFunding = revenuePenetrationFor0PercentSellerFunding;
        return this;
    }

    @Schema(description="The percentage of subscription revenue generated by offers with 0% seller-funded discount over the last 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenuePenetrationFor0PercentSellerFunding() {
        return this.revenuePenetrationFor0PercentSellerFunding;
    }

    public void setRevenuePenetrationFor0PercentSellerFunding(Double revenuePenetrationFor0PercentSellerFunding) {
        this.revenuePenetrationFor0PercentSellerFunding = revenuePenetrationFor0PercentSellerFunding;
    }

    public GetSellingPartnerMetricsResponseMetric revenuePenetrationFor5PercentSellerFunding(Double revenuePenetrationFor5PercentSellerFunding) {
        this.revenuePenetrationFor5PercentSellerFunding = revenuePenetrationFor5PercentSellerFunding;
        return this;
    }

    @Schema(description="[Applicable only for Sellers] The percentage of subscription revenue generated by offers with 5% seller-funded discount over the last 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenuePenetrationFor5PercentSellerFunding() {
        return this.revenuePenetrationFor5PercentSellerFunding;
    }

    public void setRevenuePenetrationFor5PercentSellerFunding(Double revenuePenetrationFor5PercentSellerFunding) {
        this.revenuePenetrationFor5PercentSellerFunding = revenuePenetrationFor5PercentSellerFunding;
    }

    public GetSellingPartnerMetricsResponseMetric revenuePenetrationFor10PercentSellerFunding(Double revenuePenetrationFor10PercentSellerFunding) {
        this.revenuePenetrationFor10PercentSellerFunding = revenuePenetrationFor10PercentSellerFunding;
        return this;
    }

    @Schema(description="[Applicable only for Sellers] The percentage of subscription revenue generated by offers with 10% seller-funded discount over the last 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenuePenetrationFor10PercentSellerFunding() {
        return this.revenuePenetrationFor10PercentSellerFunding;
    }

    public void setRevenuePenetrationFor10PercentSellerFunding(Double revenuePenetrationFor10PercentSellerFunding) {
        this.revenuePenetrationFor10PercentSellerFunding = revenuePenetrationFor10PercentSellerFunding;
    }

    public GetSellingPartnerMetricsResponseMetric revenuePenetrationFor5PlusPercentSellerFunding(Double revenuePenetrationFor5PlusPercentSellerFunding) {
        this.revenuePenetrationFor5PlusPercentSellerFunding = revenuePenetrationFor5PlusPercentSellerFunding;
        return this;
    }

    @Schema(description="[Applicable only for vendors] The percentage of subscription revenue generated by offers with 5% or above seller-funded discount over the last 12 months. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenuePenetrationFor5PlusPercentSellerFunding() {
        return this.revenuePenetrationFor5PlusPercentSellerFunding;
    }

    public void setRevenuePenetrationFor5PlusPercentSellerFunding(Double revenuePenetrationFor5PlusPercentSellerFunding) {
        this.revenuePenetrationFor5PlusPercentSellerFunding = revenuePenetrationFor5PlusPercentSellerFunding;
    }

    public GetSellingPartnerMetricsResponseMetric shareOfCouponSubscriptions(Double shareOfCouponSubscriptions) {
        this.shareOfCouponSubscriptions = shareOfCouponSubscriptions;
        return this;
    }

    @Schema(description="The percentage of new subscriptions acquired through coupons. Applicable to PERFORMANCE timePeriodType.")
    public Double getShareOfCouponSubscriptions() {
        return this.shareOfCouponSubscriptions;
    }

    public void setShareOfCouponSubscriptions(Double shareOfCouponSubscriptions) {
        this.shareOfCouponSubscriptions = shareOfCouponSubscriptions;
    }

    public GetSellingPartnerMetricsResponseMetric timeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    @Schema(description="")
    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public GetSellingPartnerMetricsResponseMetric currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="The currency code in ISO 4217 format.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSellingPartnerMetricsResponseMetric getSellingPartnerMetricsResponseMetric = (GetSellingPartnerMetricsResponseMetric)o;
        return Objects.equals(this.notDeliveredDueToOOS, getSellingPartnerMetricsResponseMetric.notDeliveredDueToOOS) && Objects.equals(this.totalSubscriptionsRevenue, getSellingPartnerMetricsResponseMetric.totalSubscriptionsRevenue) && Objects.equals(this.shippedSubscriptionUnits, getSellingPartnerMetricsResponseMetric.shippedSubscriptionUnits) && Objects.equals(this.activeSubscriptions, getSellingPartnerMetricsResponseMetric.activeSubscriptions) && Objects.equals(this.subscriberAverageRevenue, getSellingPartnerMetricsResponseMetric.subscriberAverageRevenue) && Objects.equals(this.nonSubscriberAverageRevenue, getSellingPartnerMetricsResponseMetric.nonSubscriberAverageRevenue) && Objects.equals(this.lostRevenueDueToOOS, getSellingPartnerMetricsResponseMetric.lostRevenueDueToOOS) && Objects.equals(this.subscriberAverageReorders, getSellingPartnerMetricsResponseMetric.subscriberAverageReorders) && Objects.equals(this.nonSubscriberAverageReorders, getSellingPartnerMetricsResponseMetric.nonSubscriberAverageReorders) && Objects.equals(this.couponsRevenuePenetration, getSellingPartnerMetricsResponseMetric.couponsRevenuePenetration) && Objects.equals(this.revenueFromSubscriptionsWithMultipleDeliveries, getSellingPartnerMetricsResponseMetric.revenueFromSubscriptionsWithMultipleDeliveries) && Objects.equals(this.revenueFromActiveSubscriptionsWithSingleDelivery, getSellingPartnerMetricsResponseMetric.revenueFromActiveSubscriptionsWithSingleDelivery) && Objects.equals(this.revenueFromCancelledSubscriptionsAfterSingleDelivery, getSellingPartnerMetricsResponseMetric.revenueFromCancelledSubscriptionsAfterSingleDelivery) && Objects.equals(this.subscriberRetentionFor30Days, getSellingPartnerMetricsResponseMetric.subscriberRetentionFor30Days) && Objects.equals(this.subscriberRetentionFor90Days, getSellingPartnerMetricsResponseMetric.subscriberRetentionFor90Days) && Objects.equals(this.revenuePenetrationFor0PercentSellerFunding, getSellingPartnerMetricsResponseMetric.revenuePenetrationFor0PercentSellerFunding) && Objects.equals(this.revenuePenetrationFor5PercentSellerFunding, getSellingPartnerMetricsResponseMetric.revenuePenetrationFor5PercentSellerFunding) && Objects.equals(this.revenuePenetrationFor10PercentSellerFunding, getSellingPartnerMetricsResponseMetric.revenuePenetrationFor10PercentSellerFunding) && Objects.equals(this.revenuePenetrationFor5PlusPercentSellerFunding, getSellingPartnerMetricsResponseMetric.revenuePenetrationFor5PlusPercentSellerFunding) && Objects.equals(this.shareOfCouponSubscriptions, getSellingPartnerMetricsResponseMetric.shareOfCouponSubscriptions) && Objects.equals(this.timeInterval, getSellingPartnerMetricsResponseMetric.timeInterval) && Objects.equals(this.currencyCode, getSellingPartnerMetricsResponseMetric.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.notDeliveredDueToOOS, this.totalSubscriptionsRevenue, this.shippedSubscriptionUnits, this.activeSubscriptions, this.subscriberAverageRevenue, this.nonSubscriberAverageRevenue, this.lostRevenueDueToOOS, this.subscriberAverageReorders, this.nonSubscriberAverageReorders, this.couponsRevenuePenetration, this.revenueFromSubscriptionsWithMultipleDeliveries, this.revenueFromActiveSubscriptionsWithSingleDelivery, this.revenueFromCancelledSubscriptionsAfterSingleDelivery, this.subscriberRetentionFor30Days, this.subscriberRetentionFor90Days, this.revenuePenetrationFor0PercentSellerFunding, this.revenuePenetrationFor5PercentSellerFunding, this.revenuePenetrationFor10PercentSellerFunding, this.revenuePenetrationFor5PlusPercentSellerFunding, this.shareOfCouponSubscriptions, this.timeInterval, this.currencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetSellingPartnerMetricsResponseMetric {\n");
        sb.append("    notDeliveredDueToOOS: ").append(this.toIndentedString(this.notDeliveredDueToOOS)).append("\n");
        sb.append("    totalSubscriptionsRevenue: ").append(this.toIndentedString(this.totalSubscriptionsRevenue)).append("\n");
        sb.append("    shippedSubscriptionUnits: ").append(this.toIndentedString(this.shippedSubscriptionUnits)).append("\n");
        sb.append("    activeSubscriptions: ").append(this.toIndentedString(this.activeSubscriptions)).append("\n");
        sb.append("    subscriberAverageRevenue: ").append(this.toIndentedString(this.subscriberAverageRevenue)).append("\n");
        sb.append("    nonSubscriberAverageRevenue: ").append(this.toIndentedString(this.nonSubscriberAverageRevenue)).append("\n");
        sb.append("    lostRevenueDueToOOS: ").append(this.toIndentedString(this.lostRevenueDueToOOS)).append("\n");
        sb.append("    subscriberAverageReorders: ").append(this.toIndentedString(this.subscriberAverageReorders)).append("\n");
        sb.append("    nonSubscriberAverageReorders: ").append(this.toIndentedString(this.nonSubscriberAverageReorders)).append("\n");
        sb.append("    couponsRevenuePenetration: ").append(this.toIndentedString(this.couponsRevenuePenetration)).append("\n");
        sb.append("    revenueFromSubscriptionsWithMultipleDeliveries: ").append(this.toIndentedString(this.revenueFromSubscriptionsWithMultipleDeliveries)).append("\n");
        sb.append("    revenueFromActiveSubscriptionsWithSingleDelivery: ").append(this.toIndentedString(this.revenueFromActiveSubscriptionsWithSingleDelivery)).append("\n");
        sb.append("    revenueFromCancelledSubscriptionsAfterSingleDelivery: ").append(this.toIndentedString(this.revenueFromCancelledSubscriptionsAfterSingleDelivery)).append("\n");
        sb.append("    subscriberRetentionFor30Days: ").append(this.toIndentedString(this.subscriberRetentionFor30Days)).append("\n");
        sb.append("    subscriberRetentionFor90Days: ").append(this.toIndentedString(this.subscriberRetentionFor90Days)).append("\n");
        sb.append("    revenuePenetrationFor0PercentSellerFunding: ").append(this.toIndentedString(this.revenuePenetrationFor0PercentSellerFunding)).append("\n");
        sb.append("    revenuePenetrationFor5PercentSellerFunding: ").append(this.toIndentedString(this.revenuePenetrationFor5PercentSellerFunding)).append("\n");
        sb.append("    revenuePenetrationFor10PercentSellerFunding: ").append(this.toIndentedString(this.revenuePenetrationFor10PercentSellerFunding)).append("\n");
        sb.append("    revenuePenetrationFor5PlusPercentSellerFunding: ").append(this.toIndentedString(this.revenuePenetrationFor5PlusPercentSellerFunding)).append("\n");
        sb.append("    shareOfCouponSubscriptions: ").append(this.toIndentedString(this.shareOfCouponSubscriptions)).append("\n");
        sb.append("    timeInterval: ").append(this.toIndentedString(this.timeInterval)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

