/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.producttypedefinitions.v2020_09_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.ProductType;

@Schema(description="A list of Amazon product types with definitions available.")
public class ProductTypeList {
    @SerializedName(value="productTypes")
    private List<ProductType> productTypes = new ArrayList<ProductType>();
    @SerializedName(value="productTypeVersion")
    private String productTypeVersion = null;

    public ProductTypeList productTypes(List<ProductType> productTypes) {
        this.productTypes = productTypes;
        return this;
    }

    public ProductTypeList addProductTypesItem(ProductType productTypesItem) {
        this.productTypes.add(productTypesItem);
        return this;
    }

    @Schema(required=true, description="")
    public List<ProductType> getProductTypes() {
        return this.productTypes;
    }

    public void setProductTypes(List<ProductType> productTypes) {
        this.productTypes = productTypes;
    }

    public ProductTypeList productTypeVersion(String productTypeVersion) {
        this.productTypeVersion = productTypeVersion;
        return this;
    }

    @Schema(required=true, description="Amazon product type version identifier.")
    public String getProductTypeVersion() {
        return this.productTypeVersion;
    }

    public void setProductTypeVersion(String productTypeVersion) {
        this.productTypeVersion = productTypeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductTypeList productTypeList = (ProductTypeList)o;
        return Objects.equals(this.productTypes, productTypeList.productTypes) && Objects.equals(this.productTypeVersion, productTypeList.productTypeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.productTypes, this.productTypeVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductTypeList {\n");
        sb.append("    productTypes: ").append(this.toIndentedString(this.productTypes)).append("\n");
        sb.append("    productTypeVersion: ").append(this.toIndentedString(this.productTypeVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

