/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.pricing.v0.BuyBoxEligibleOffers;
import software.amazon.spapi.models.pricing.v0.BuyBoxPrices;
import software.amazon.spapi.models.pricing.v0.LowestPrices;
import software.amazon.spapi.models.pricing.v0.MoneyType;
import software.amazon.spapi.models.pricing.v0.NumberOfOffers;
import software.amazon.spapi.models.pricing.v0.SalesRankList;

@Schema(description="Contains price information about the product, including the LowestPrices and BuyBoxPrices, the ListPrice, the SuggestedLowerPricePlusShipping, and NumberOfOffers and NumberOfBuyBoxEligibleOffers.")
public class Summary {
    @SerializedName(value="TotalOfferCount")
    private Integer totalOfferCount = null;
    @SerializedName(value="NumberOfOffers")
    private NumberOfOffers numberOfOffers = null;
    @SerializedName(value="LowestPrices")
    private LowestPrices lowestPrices = null;
    @SerializedName(value="BuyBoxPrices")
    private BuyBoxPrices buyBoxPrices = null;
    @SerializedName(value="ListPrice")
    private MoneyType listPrice = null;
    @SerializedName(value="CompetitivePriceThreshold")
    private MoneyType competitivePriceThreshold = null;
    @SerializedName(value="SuggestedLowerPricePlusShipping")
    private MoneyType suggestedLowerPricePlusShipping = null;
    @SerializedName(value="SalesRankings")
    private SalesRankList salesRankings = null;
    @SerializedName(value="BuyBoxEligibleOffers")
    private BuyBoxEligibleOffers buyBoxEligibleOffers = null;
    @SerializedName(value="OffersAvailableTime")
    private OffsetDateTime offersAvailableTime = null;

    public Summary totalOfferCount(Integer totalOfferCount) {
        this.totalOfferCount = totalOfferCount;
        return this;
    }

    @Schema(required=true, description="The number of unique offers contained in NumberOfOffers.")
    public Integer getTotalOfferCount() {
        return this.totalOfferCount;
    }

    public void setTotalOfferCount(Integer totalOfferCount) {
        this.totalOfferCount = totalOfferCount;
    }

    public Summary numberOfOffers(NumberOfOffers numberOfOffers) {
        this.numberOfOffers = numberOfOffers;
        return this;
    }

    @Schema(description="")
    public NumberOfOffers getNumberOfOffers() {
        return this.numberOfOffers;
    }

    public void setNumberOfOffers(NumberOfOffers numberOfOffers) {
        this.numberOfOffers = numberOfOffers;
    }

    public Summary lowestPrices(LowestPrices lowestPrices) {
        this.lowestPrices = lowestPrices;
        return this;
    }

    @Schema(description="")
    public LowestPrices getLowestPrices() {
        return this.lowestPrices;
    }

    public void setLowestPrices(LowestPrices lowestPrices) {
        this.lowestPrices = lowestPrices;
    }

    public Summary buyBoxPrices(BuyBoxPrices buyBoxPrices) {
        this.buyBoxPrices = buyBoxPrices;
        return this;
    }

    @Schema(description="")
    public BuyBoxPrices getBuyBoxPrices() {
        return this.buyBoxPrices;
    }

    public void setBuyBoxPrices(BuyBoxPrices buyBoxPrices) {
        this.buyBoxPrices = buyBoxPrices;
    }

    public Summary listPrice(MoneyType listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Schema(description="")
    public MoneyType getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(MoneyType listPrice) {
        this.listPrice = listPrice;
    }

    public Summary competitivePriceThreshold(MoneyType competitivePriceThreshold) {
        this.competitivePriceThreshold = competitivePriceThreshold;
        return this;
    }

    @Schema(description="")
    public MoneyType getCompetitivePriceThreshold() {
        return this.competitivePriceThreshold;
    }

    public void setCompetitivePriceThreshold(MoneyType competitivePriceThreshold) {
        this.competitivePriceThreshold = competitivePriceThreshold;
    }

    public Summary suggestedLowerPricePlusShipping(MoneyType suggestedLowerPricePlusShipping) {
        this.suggestedLowerPricePlusShipping = suggestedLowerPricePlusShipping;
        return this;
    }

    @Schema(description="")
    public MoneyType getSuggestedLowerPricePlusShipping() {
        return this.suggestedLowerPricePlusShipping;
    }

    public void setSuggestedLowerPricePlusShipping(MoneyType suggestedLowerPricePlusShipping) {
        this.suggestedLowerPricePlusShipping = suggestedLowerPricePlusShipping;
    }

    public Summary salesRankings(SalesRankList salesRankings) {
        this.salesRankings = salesRankings;
        return this;
    }

    @Schema(description="")
    public SalesRankList getSalesRankings() {
        return this.salesRankings;
    }

    public void setSalesRankings(SalesRankList salesRankings) {
        this.salesRankings = salesRankings;
    }

    public Summary buyBoxEligibleOffers(BuyBoxEligibleOffers buyBoxEligibleOffers) {
        this.buyBoxEligibleOffers = buyBoxEligibleOffers;
        return this;
    }

    @Schema(description="")
    public BuyBoxEligibleOffers getBuyBoxEligibleOffers() {
        return this.buyBoxEligibleOffers;
    }

    public void setBuyBoxEligibleOffers(BuyBoxEligibleOffers buyBoxEligibleOffers) {
        this.buyBoxEligibleOffers = buyBoxEligibleOffers;
    }

    public Summary offersAvailableTime(OffsetDateTime offersAvailableTime) {
        this.offersAvailableTime = offersAvailableTime;
        return this;
    }

    @Schema(description="When the status is ActiveButTooSoonForProcessing, this is the time when the offers will be available for processing.")
    public OffsetDateTime getOffersAvailableTime() {
        return this.offersAvailableTime;
    }

    public void setOffersAvailableTime(OffsetDateTime offersAvailableTime) {
        this.offersAvailableTime = offersAvailableTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Summary summary = (Summary)o;
        return Objects.equals(this.totalOfferCount, summary.totalOfferCount) && Objects.equals(this.numberOfOffers, summary.numberOfOffers) && Objects.equals(this.lowestPrices, summary.lowestPrices) && Objects.equals(this.buyBoxPrices, summary.buyBoxPrices) && Objects.equals(this.listPrice, summary.listPrice) && Objects.equals(this.competitivePriceThreshold, summary.competitivePriceThreshold) && Objects.equals(this.suggestedLowerPricePlusShipping, summary.suggestedLowerPricePlusShipping) && Objects.equals(this.salesRankings, summary.salesRankings) && Objects.equals(this.buyBoxEligibleOffers, summary.buyBoxEligibleOffers) && Objects.equals(this.offersAvailableTime, summary.offersAvailableTime);
    }

    public int hashCode() {
        return Objects.hash(this.totalOfferCount, this.numberOfOffers, this.lowestPrices, this.buyBoxPrices, this.listPrice, this.competitivePriceThreshold, this.suggestedLowerPricePlusShipping, this.salesRankings, this.buyBoxEligibleOffers, this.offersAvailableTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Summary {\n");
        sb.append("    totalOfferCount: ").append(this.toIndentedString(this.totalOfferCount)).append("\n");
        sb.append("    numberOfOffers: ").append(this.toIndentedString(this.numberOfOffers)).append("\n");
        sb.append("    lowestPrices: ").append(this.toIndentedString(this.lowestPrices)).append("\n");
        sb.append("    buyBoxPrices: ").append(this.toIndentedString(this.buyBoxPrices)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    competitivePriceThreshold: ").append(this.toIndentedString(this.competitivePriceThreshold)).append("\n");
        sb.append("    suggestedLowerPricePlusShipping: ").append(this.toIndentedString(this.suggestedLowerPricePlusShipping)).append("\n");
        sb.append("    salesRankings: ").append(this.toIndentedString(this.salesRankings)).append("\n");
        sb.append("    buyBoxEligibleOffers: ").append(this.toIndentedString(this.buyBoxEligibleOffers)).append("\n");
        sb.append("    offersAvailableTime: ").append(this.toIndentedString(this.offersAvailableTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

