/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.MoneyType;
import software.amazon.spapi.models.pricing.v0.OfferCustomerType;
import software.amazon.spapi.models.pricing.v0.PriceType;
import software.amazon.spapi.models.pricing.v0.QuantityDiscountPriceType;

@Schema(description="Schema for an individual offer.")
public class OfferType {
    @SerializedName(value="offerType")
    private OfferCustomerType offerType = null;
    @SerializedName(value="BuyingPrice")
    private PriceType buyingPrice = null;
    @SerializedName(value="RegularPrice")
    private MoneyType regularPrice = null;
    @SerializedName(value="businessPrice")
    private MoneyType businessPrice = null;
    @SerializedName(value="quantityDiscountPrices")
    private List<QuantityDiscountPriceType> quantityDiscountPrices = null;
    @SerializedName(value="FulfillmentChannel")
    private String fulfillmentChannel = null;
    @SerializedName(value="ItemCondition")
    private String itemCondition = null;
    @SerializedName(value="ItemSubCondition")
    private String itemSubCondition = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;

    public OfferType offerType(OfferCustomerType offerType) {
        this.offerType = offerType;
        return this;
    }

    @Schema(description="")
    public OfferCustomerType getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferCustomerType offerType) {
        this.offerType = offerType;
    }

    public OfferType buyingPrice(PriceType buyingPrice) {
        this.buyingPrice = buyingPrice;
        return this;
    }

    @Schema(required=true, description="")
    public PriceType getBuyingPrice() {
        return this.buyingPrice;
    }

    public void setBuyingPrice(PriceType buyingPrice) {
        this.buyingPrice = buyingPrice;
    }

    public OfferType regularPrice(MoneyType regularPrice) {
        this.regularPrice = regularPrice;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getRegularPrice() {
        return this.regularPrice;
    }

    public void setRegularPrice(MoneyType regularPrice) {
        this.regularPrice = regularPrice;
    }

    public OfferType businessPrice(MoneyType businessPrice) {
        this.businessPrice = businessPrice;
        return this;
    }

    @Schema(description="")
    public MoneyType getBusinessPrice() {
        return this.businessPrice;
    }

    public void setBusinessPrice(MoneyType businessPrice) {
        this.businessPrice = businessPrice;
    }

    public OfferType quantityDiscountPrices(List<QuantityDiscountPriceType> quantityDiscountPrices) {
        this.quantityDiscountPrices = quantityDiscountPrices;
        return this;
    }

    public OfferType addQuantityDiscountPricesItem(QuantityDiscountPriceType quantityDiscountPricesItem) {
        if (this.quantityDiscountPrices == null) {
            this.quantityDiscountPrices = new ArrayList<QuantityDiscountPriceType>();
        }
        this.quantityDiscountPrices.add(quantityDiscountPricesItem);
        return this;
    }

    @Schema(description="List of `QuantityDiscountPrice` that contains item's pricing information when buy in bulk.")
    public List<QuantityDiscountPriceType> getQuantityDiscountPrices() {
        return this.quantityDiscountPrices;
    }

    public void setQuantityDiscountPrices(List<QuantityDiscountPriceType> quantityDiscountPrices) {
        this.quantityDiscountPrices = quantityDiscountPrices;
    }

    public OfferType fulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
        return this;
    }

    @Schema(required=true, description="The fulfillment channel for the offer listing. Possible values:  * Amazon - Fulfilled by Amazon. * Merchant - Fulfilled by the seller.")
    public String getFulfillmentChannel() {
        return this.fulfillmentChannel;
    }

    public void setFulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
    }

    public OfferType itemCondition(String itemCondition) {
        this.itemCondition = itemCondition;
        return this;
    }

    @Schema(required=true, description="The item condition for the offer listing. Possible values: New, Used, Collectible, Refurbished, or Club.")
    public String getItemCondition() {
        return this.itemCondition;
    }

    public void setItemCondition(String itemCondition) {
        this.itemCondition = itemCondition;
    }

    public OfferType itemSubCondition(String itemSubCondition) {
        this.itemSubCondition = itemSubCondition;
        return this;
    }

    @Schema(required=true, description="The item subcondition for the offer listing. Possible values: New, Mint, Very Good, Good, Acceptable, Poor, Club, OEM, Warranty, Refurbished Warranty, Refurbished, Open Box, or Other.")
    public String getItemSubCondition() {
        return this.itemSubCondition;
    }

    public void setItemSubCondition(String itemSubCondition) {
        this.itemSubCondition = itemSubCondition;
    }

    public OfferType sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @Schema(required=true, description="The seller stock keeping unit (SKU) of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferType offerType = (OfferType)o;
        return Objects.equals((Object)this.offerType, (Object)offerType.offerType) && Objects.equals(this.buyingPrice, offerType.buyingPrice) && Objects.equals(this.regularPrice, offerType.regularPrice) && Objects.equals(this.businessPrice, offerType.businessPrice) && Objects.equals(this.quantityDiscountPrices, offerType.quantityDiscountPrices) && Objects.equals(this.fulfillmentChannel, offerType.fulfillmentChannel) && Objects.equals(this.itemCondition, offerType.itemCondition) && Objects.equals(this.itemSubCondition, offerType.itemSubCondition) && Objects.equals(this.sellerSKU, offerType.sellerSKU);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offerType, this.buyingPrice, this.regularPrice, this.businessPrice, this.quantityDiscountPrices, this.fulfillmentChannel, this.itemCondition, this.itemSubCondition, this.sellerSKU});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferType {\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    buyingPrice: ").append(this.toIndentedString(this.buyingPrice)).append("\n");
        sb.append("    regularPrice: ").append(this.toIndentedString(this.regularPrice)).append("\n");
        sb.append("    businessPrice: ").append(this.toIndentedString(this.businessPrice)).append("\n");
        sb.append("    quantityDiscountPrices: ").append(this.toIndentedString(this.quantityDiscountPrices)).append("\n");
        sb.append("    fulfillmentChannel: ").append(this.toIndentedString(this.fulfillmentChannel)).append("\n");
        sb.append("    itemCondition: ").append(this.toIndentedString(this.itemCondition)).append("\n");
        sb.append("    itemSubCondition: ").append(this.toIndentedString(this.itemSubCondition)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

