/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.MoneyType;
import software.amazon.spapi.models.pricing.v0.OfferCustomerType;
import software.amazon.spapi.models.pricing.v0.Points;
import software.amazon.spapi.models.pricing.v0.QuantityDiscountType;

@Schema(description="Schema for an individual buybox price.")
public class BuyBoxPriceType {
    @SerializedName(value="condition")
    private String condition = null;
    @SerializedName(value="offerType")
    private OfferCustomerType offerType = null;
    @SerializedName(value="quantityTier")
    private Integer quantityTier = null;
    @SerializedName(value="quantityDiscountType")
    private QuantityDiscountType quantityDiscountType = null;
    @SerializedName(value="LandedPrice")
    private MoneyType landedPrice = null;
    @SerializedName(value="ListingPrice")
    private MoneyType listingPrice = null;
    @SerializedName(value="Shipping")
    private MoneyType shipping = null;
    @SerializedName(value="Points")
    private Points points = null;
    @SerializedName(value="sellerId")
    private String sellerId = null;

    public BuyBoxPriceType condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Schema(required=true, description="Indicates the condition of the item. For example: New, Used, Collectible, Refurbished, or Club.")
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public BuyBoxPriceType offerType(OfferCustomerType offerType) {
        this.offerType = offerType;
        return this;
    }

    @Schema(description="")
    public OfferCustomerType getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferCustomerType offerType) {
        this.offerType = offerType;
    }

    public BuyBoxPriceType quantityTier(Integer quantityTier) {
        this.quantityTier = quantityTier;
        return this;
    }

    @Schema(description="Indicates at what quantity this price becomes active.")
    public Integer getQuantityTier() {
        return this.quantityTier;
    }

    public void setQuantityTier(Integer quantityTier) {
        this.quantityTier = quantityTier;
    }

    public BuyBoxPriceType quantityDiscountType(QuantityDiscountType quantityDiscountType) {
        this.quantityDiscountType = quantityDiscountType;
        return this;
    }

    @Schema(description="")
    public QuantityDiscountType getQuantityDiscountType() {
        return this.quantityDiscountType;
    }

    public void setQuantityDiscountType(QuantityDiscountType quantityDiscountType) {
        this.quantityDiscountType = quantityDiscountType;
    }

    public BuyBoxPriceType landedPrice(MoneyType landedPrice) {
        this.landedPrice = landedPrice;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getLandedPrice() {
        return this.landedPrice;
    }

    public void setLandedPrice(MoneyType landedPrice) {
        this.landedPrice = landedPrice;
    }

    public BuyBoxPriceType listingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getListingPrice() {
        return this.listingPrice;
    }

    public void setListingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
    }

    public BuyBoxPriceType shipping(MoneyType shipping) {
        this.shipping = shipping;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getShipping() {
        return this.shipping;
    }

    public void setShipping(MoneyType shipping) {
        this.shipping = shipping;
    }

    public BuyBoxPriceType points(Points points) {
        this.points = points;
        return this;
    }

    @Schema(description="")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public BuyBoxPriceType sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The seller identifier for the offer.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuyBoxPriceType buyBoxPriceType = (BuyBoxPriceType)o;
        return Objects.equals(this.condition, buyBoxPriceType.condition) && Objects.equals((Object)this.offerType, (Object)buyBoxPriceType.offerType) && Objects.equals(this.quantityTier, buyBoxPriceType.quantityTier) && Objects.equals((Object)this.quantityDiscountType, (Object)buyBoxPriceType.quantityDiscountType) && Objects.equals(this.landedPrice, buyBoxPriceType.landedPrice) && Objects.equals(this.listingPrice, buyBoxPriceType.listingPrice) && Objects.equals(this.shipping, buyBoxPriceType.shipping) && Objects.equals(this.points, buyBoxPriceType.points) && Objects.equals(this.sellerId, buyBoxPriceType.sellerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.offerType, this.quantityTier, this.quantityDiscountType, this.landedPrice, this.listingPrice, this.shipping, this.points, this.sellerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuyBoxPriceType {\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    quantityTier: ").append(this.toIndentedString(this.quantityTier)).append("\n");
        sb.append("    quantityDiscountType: ").append(this.toIndentedString((Object)this.quantityDiscountType)).append("\n");
        sb.append("    landedPrice: ").append(this.toIndentedString(this.landedPrice)).append("\n");
        sb.append("    listingPrice: ").append(this.toIndentedString(this.listingPrice)).append("\n");
        sb.append("    shipping: ").append(this.toIndentedString(this.shipping)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

