/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.Money;

@Schema(description="Information about a sub-payment method used to pay for a COD order.")
public class PaymentExecutionDetailItem {
    @SerializedName(value="Payment")
    private Money payment = null;
    @SerializedName(value="PaymentMethod")
    private String paymentMethod = null;
    @SerializedName(value="AcquirerId")
    private String acquirerId = null;
    @SerializedName(value="CardBrand")
    private String cardBrand = null;
    @SerializedName(value="AuthorizationCode")
    private String authorizationCode = null;

    public PaymentExecutionDetailItem payment(Money payment) {
        this.payment = payment;
        return this;
    }

    @Schema(required=true, description="")
    public Money getPayment() {
        return this.payment;
    }

    public void setPayment(Money payment) {
        this.payment = payment;
    }

    public PaymentExecutionDetailItem paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(required=true, description="The sub-payment method for an order.   **Possible values**: * `COD`: Cash on delivery  * `GC`: Gift card  * `PointsAccount`: Amazon Points  * `Invoice`: Invoice  * `CreditCard`: Credit card  * `Pix`: Pix  * `Other`: Other.")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentExecutionDetailItem acquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
        return this;
    }

    @Schema(description="The Brazilian Taxpayer Identifier (CNPJ) of the payment processor or acquiring bank that authorizes the payment.   **Note**: This attribute is only available for orders in the Brazil (BR) marketplace when the `PaymentMethod` is `CreditCard` or `Pix`.")
    public String getAcquirerId() {
        return this.acquirerId;
    }

    public void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    public PaymentExecutionDetailItem cardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
        return this;
    }

    @Schema(description="The card network or brand used in the payment transaction (for example, Visa or Mastercard).   **Note**: This attribute is only available for orders in the Brazil (BR) marketplace when the `PaymentMethod` is `CreditCard`.")
    public String getCardBrand() {
        return this.cardBrand;
    }

    public void setCardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
    }

    public PaymentExecutionDetailItem authorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
        return this;
    }

    @Schema(description="The unique code that confirms the payment authorization.   **Note**: This attribute is only available for orders in the Brazil (BR) marketplace when the `PaymentMethod` is `CreditCard` or `Pix`.")
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentExecutionDetailItem paymentExecutionDetailItem = (PaymentExecutionDetailItem)o;
        return Objects.equals(this.payment, paymentExecutionDetailItem.payment) && Objects.equals(this.paymentMethod, paymentExecutionDetailItem.paymentMethod) && Objects.equals(this.acquirerId, paymentExecutionDetailItem.acquirerId) && Objects.equals(this.cardBrand, paymentExecutionDetailItem.cardBrand) && Objects.equals(this.authorizationCode, paymentExecutionDetailItem.authorizationCode);
    }

    public int hashCode() {
        return Objects.hash(this.payment, this.paymentMethod, this.acquirerId, this.cardBrand, this.authorizationCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentExecutionDetailItem {\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    acquirerId: ").append(this.toIndentedString(this.acquirerId)).append("\n");
        sb.append("    cardBrand: ").append(this.toIndentedString(this.cardBrand)).append("\n");
        sb.append("    authorizationCode: ").append(this.toIndentedString(this.authorizationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

