/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.RegulatedInformation;
import software.amazon.spapi.models.orders.v0.RegulatedOrderVerificationStatus;

@Schema(description="The order's regulated information along with its verification status.")
public class OrderRegulatedInfo {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="RegulatedInformation")
    private RegulatedInformation regulatedInformation = null;
    @SerializedName(value="RequiresDosageLabel")
    private Boolean requiresDosageLabel = null;
    @SerializedName(value="RegulatedOrderVerificationStatus")
    private RegulatedOrderVerificationStatus regulatedOrderVerificationStatus = null;

    public OrderRegulatedInfo amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order identifier, in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public OrderRegulatedInfo regulatedInformation(RegulatedInformation regulatedInformation) {
        this.regulatedInformation = regulatedInformation;
        return this;
    }

    @Schema(required=true, description="")
    public RegulatedInformation getRegulatedInformation() {
        return this.regulatedInformation;
    }

    public void setRegulatedInformation(RegulatedInformation regulatedInformation) {
        this.regulatedInformation = regulatedInformation;
    }

    public OrderRegulatedInfo requiresDosageLabel(Boolean requiresDosageLabel) {
        this.requiresDosageLabel = requiresDosageLabel;
        return this;
    }

    @Schema(required=true, description="When true, the order requires attaching a dosage information label when shipped.")
    public Boolean isRequiresDosageLabel() {
        return this.requiresDosageLabel;
    }

    public void setRequiresDosageLabel(Boolean requiresDosageLabel) {
        this.requiresDosageLabel = requiresDosageLabel;
    }

    public OrderRegulatedInfo regulatedOrderVerificationStatus(RegulatedOrderVerificationStatus regulatedOrderVerificationStatus) {
        this.regulatedOrderVerificationStatus = regulatedOrderVerificationStatus;
        return this;
    }

    @Schema(required=true, description="")
    public RegulatedOrderVerificationStatus getRegulatedOrderVerificationStatus() {
        return this.regulatedOrderVerificationStatus;
    }

    public void setRegulatedOrderVerificationStatus(RegulatedOrderVerificationStatus regulatedOrderVerificationStatus) {
        this.regulatedOrderVerificationStatus = regulatedOrderVerificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderRegulatedInfo orderRegulatedInfo = (OrderRegulatedInfo)o;
        return Objects.equals(this.amazonOrderId, orderRegulatedInfo.amazonOrderId) && Objects.equals(this.regulatedInformation, orderRegulatedInfo.regulatedInformation) && Objects.equals(this.requiresDosageLabel, orderRegulatedInfo.requiresDosageLabel) && Objects.equals(this.regulatedOrderVerificationStatus, orderRegulatedInfo.regulatedOrderVerificationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.regulatedInformation, this.requiresDosageLabel, this.regulatedOrderVerificationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderRegulatedInfo {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    regulatedInformation: ").append(this.toIndentedString(this.regulatedInformation)).append("\n");
        sb.append("    requiresDosageLabel: ").append(this.toIndentedString(this.requiresDosageLabel)).append("\n");
        sb.append("    regulatedOrderVerificationStatus: ").append(this.toIndentedString(this.regulatedOrderVerificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

