/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.AmazonPrograms;
import software.amazon.spapi.models.orders.v0.AssociatedItem;
import software.amazon.spapi.models.orders.v0.BuyerRequestedCancel;
import software.amazon.spapi.models.orders.v0.ItemBuyerInfo;
import software.amazon.spapi.models.orders.v0.Measurement;
import software.amazon.spapi.models.orders.v0.Money;
import software.amazon.spapi.models.orders.v0.PointsGrantedDetail;
import software.amazon.spapi.models.orders.v0.ProductInfoDetail;
import software.amazon.spapi.models.orders.v0.PromotionIdList;
import software.amazon.spapi.models.orders.v0.ShippingConstraints;
import software.amazon.spapi.models.orders.v0.SubstitutionPreferences;
import software.amazon.spapi.models.orders.v0.TaxCollection;

@Schema(description="A single order item.")
public class OrderItem {
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="AssociatedItems")
    private List<AssociatedItem> associatedItems = null;
    @SerializedName(value="Title")
    private String title = null;
    @SerializedName(value="QuantityOrdered")
    private Integer quantityOrdered = null;
    @SerializedName(value="QuantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="ProductInfo")
    private ProductInfoDetail productInfo = null;
    @SerializedName(value="PointsGranted")
    private PointsGrantedDetail pointsGranted = null;
    @SerializedName(value="ItemPrice")
    private Money itemPrice = null;
    @SerializedName(value="ShippingPrice")
    private Money shippingPrice = null;
    @SerializedName(value="ItemTax")
    private Money itemTax = null;
    @SerializedName(value="ShippingTax")
    private Money shippingTax = null;
    @SerializedName(value="ShippingDiscount")
    private Money shippingDiscount = null;
    @SerializedName(value="ShippingDiscountTax")
    private Money shippingDiscountTax = null;
    @SerializedName(value="PromotionDiscount")
    private Money promotionDiscount = null;
    @SerializedName(value="PromotionDiscountTax")
    private Money promotionDiscountTax = null;
    @SerializedName(value="PromotionIds")
    private PromotionIdList promotionIds = null;
    @SerializedName(value="CODFee")
    private Money coDFee = null;
    @SerializedName(value="CODFeeDiscount")
    private Money coDFeeDiscount = null;
    @SerializedName(value="IsGift")
    private String isGift = null;
    @SerializedName(value="ConditionNote")
    private String conditionNote = null;
    @SerializedName(value="ConditionId")
    private String conditionId = null;
    @SerializedName(value="ConditionSubtypeId")
    private String conditionSubtypeId = null;
    @SerializedName(value="ScheduledDeliveryStartDate")
    private String scheduledDeliveryStartDate = null;
    @SerializedName(value="ScheduledDeliveryEndDate")
    private String scheduledDeliveryEndDate = null;
    @SerializedName(value="PriceDesignation")
    private String priceDesignation = null;
    @SerializedName(value="TaxCollection")
    private TaxCollection taxCollection = null;
    @SerializedName(value="SerialNumberRequired")
    private Boolean serialNumberRequired = null;
    @SerializedName(value="IsTransparency")
    private Boolean isTransparency = null;
    @SerializedName(value="IossNumber")
    private String iossNumber = null;
    @SerializedName(value="StoreChainStoreId")
    private String storeChainStoreId = null;
    @SerializedName(value="DeemedResellerCategory")
    private DeemedResellerCategoryEnum deemedResellerCategory = null;
    @SerializedName(value="BuyerInfo")
    private ItemBuyerInfo buyerInfo = null;
    @SerializedName(value="BuyerRequestedCancel")
    private BuyerRequestedCancel buyerRequestedCancel = null;
    @SerializedName(value="SerialNumbers")
    private List<String> serialNumbers = null;
    @SerializedName(value="SubstitutionPreferences")
    private SubstitutionPreferences substitutionPreferences = null;
    @SerializedName(value="Measurement")
    private Measurement measurement = null;
    @SerializedName(value="ShippingConstraints")
    private ShippingConstraints shippingConstraints = null;
    @SerializedName(value="AmazonPrograms")
    private AmazonPrograms amazonPrograms = null;

    public OrderItem ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(required=true, description="The item's Amazon Standard Identification Number (ASIN).")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public OrderItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @Schema(description="The item's seller stock keeping unit (SKU).")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public OrderItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order item identifier.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public OrderItem associatedItems(List<AssociatedItem> associatedItems) {
        this.associatedItems = associatedItems;
        return this;
    }

    public OrderItem addAssociatedItemsItem(AssociatedItem associatedItemsItem) {
        if (this.associatedItems == null) {
            this.associatedItems = new ArrayList<AssociatedItem>();
        }
        this.associatedItems.add(associatedItemsItem);
        return this;
    }

    @Schema(description="A list of associated items that a customer has purchased with a product. For example, a tire installation service purchased with tires.")
    public List<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    public void setAssociatedItems(List<AssociatedItem> associatedItems) {
        this.associatedItems = associatedItems;
    }

    public OrderItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The item's name.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OrderItem quantityOrdered(Integer quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
        return this;
    }

    @Schema(required=true, description="The number of items in the order. ")
    public Integer getQuantityOrdered() {
        return this.quantityOrdered;
    }

    public void setQuantityOrdered(Integer quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
    }

    public OrderItem quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @Schema(description="The number of items shipped.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public OrderItem productInfo(ProductInfoDetail productInfo) {
        this.productInfo = productInfo;
        return this;
    }

    @Schema(description="")
    public ProductInfoDetail getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInfoDetail productInfo) {
        this.productInfo = productInfo;
    }

    public OrderItem pointsGranted(PointsGrantedDetail pointsGranted) {
        this.pointsGranted = pointsGranted;
        return this;
    }

    @Schema(description="")
    public PointsGrantedDetail getPointsGranted() {
        return this.pointsGranted;
    }

    public void setPointsGranted(PointsGrantedDetail pointsGranted) {
        this.pointsGranted = pointsGranted;
    }

    public OrderItem itemPrice(Money itemPrice) {
        this.itemPrice = itemPrice;
        return this;
    }

    @Schema(description="")
    public Money getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(Money itemPrice) {
        this.itemPrice = itemPrice;
    }

    public OrderItem shippingPrice(Money shippingPrice) {
        this.shippingPrice = shippingPrice;
        return this;
    }

    @Schema(description="")
    public Money getShippingPrice() {
        return this.shippingPrice;
    }

    public void setShippingPrice(Money shippingPrice) {
        this.shippingPrice = shippingPrice;
    }

    public OrderItem itemTax(Money itemTax) {
        this.itemTax = itemTax;
        return this;
    }

    @Schema(description="")
    public Money getItemTax() {
        return this.itemTax;
    }

    public void setItemTax(Money itemTax) {
        this.itemTax = itemTax;
    }

    public OrderItem shippingTax(Money shippingTax) {
        this.shippingTax = shippingTax;
        return this;
    }

    @Schema(description="")
    public Money getShippingTax() {
        return this.shippingTax;
    }

    public void setShippingTax(Money shippingTax) {
        this.shippingTax = shippingTax;
    }

    public OrderItem shippingDiscount(Money shippingDiscount) {
        this.shippingDiscount = shippingDiscount;
        return this;
    }

    @Schema(description="")
    public Money getShippingDiscount() {
        return this.shippingDiscount;
    }

    public void setShippingDiscount(Money shippingDiscount) {
        this.shippingDiscount = shippingDiscount;
    }

    public OrderItem shippingDiscountTax(Money shippingDiscountTax) {
        this.shippingDiscountTax = shippingDiscountTax;
        return this;
    }

    @Schema(description="")
    public Money getShippingDiscountTax() {
        return this.shippingDiscountTax;
    }

    public void setShippingDiscountTax(Money shippingDiscountTax) {
        this.shippingDiscountTax = shippingDiscountTax;
    }

    public OrderItem promotionDiscount(Money promotionDiscount) {
        this.promotionDiscount = promotionDiscount;
        return this;
    }

    @Schema(description="")
    public Money getPromotionDiscount() {
        return this.promotionDiscount;
    }

    public void setPromotionDiscount(Money promotionDiscount) {
        this.promotionDiscount = promotionDiscount;
    }

    public OrderItem promotionDiscountTax(Money promotionDiscountTax) {
        this.promotionDiscountTax = promotionDiscountTax;
        return this;
    }

    @Schema(description="")
    public Money getPromotionDiscountTax() {
        return this.promotionDiscountTax;
    }

    public void setPromotionDiscountTax(Money promotionDiscountTax) {
        this.promotionDiscountTax = promotionDiscountTax;
    }

    public OrderItem promotionIds(PromotionIdList promotionIds) {
        this.promotionIds = promotionIds;
        return this;
    }

    @Schema(description="")
    public PromotionIdList getPromotionIds() {
        return this.promotionIds;
    }

    public void setPromotionIds(PromotionIdList promotionIds) {
        this.promotionIds = promotionIds;
    }

    public OrderItem coDFee(Money coDFee) {
        this.coDFee = coDFee;
        return this;
    }

    @Schema(description="")
    public Money getCoDFee() {
        return this.coDFee;
    }

    public void setCoDFee(Money coDFee) {
        this.coDFee = coDFee;
    }

    public OrderItem coDFeeDiscount(Money coDFeeDiscount) {
        this.coDFeeDiscount = coDFeeDiscount;
        return this;
    }

    @Schema(description="")
    public Money getCoDFeeDiscount() {
        return this.coDFeeDiscount;
    }

    public void setCoDFeeDiscount(Money coDFeeDiscount) {
        this.coDFeeDiscount = coDFeeDiscount;
    }

    public OrderItem isGift(String isGift) {
        this.isGift = isGift;
        return this;
    }

    @Schema(description="Indicates whether the item is a gift.  **Possible values**: `true` and `false`.")
    public String getIsGift() {
        return this.isGift;
    }

    public void setIsGift(String isGift) {
        this.isGift = isGift;
    }

    public OrderItem conditionNote(String conditionNote) {
        this.conditionNote = conditionNote;
        return this;
    }

    @Schema(description="The condition of the item, as described by the seller.")
    public String getConditionNote() {
        return this.conditionNote;
    }

    public void setConditionNote(String conditionNote) {
        this.conditionNote = conditionNote;
    }

    public OrderItem conditionId(String conditionId) {
        this.conditionId = conditionId;
        return this;
    }

    @Schema(description="The condition of the item.  **Possible values**: `New`, `Used`, `Collectible`, `Refurbished`, `Preorder`, and `Club`.")
    public String getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }

    public OrderItem conditionSubtypeId(String conditionSubtypeId) {
        this.conditionSubtypeId = conditionSubtypeId;
        return this;
    }

    @Schema(description="The subcondition of the item.  **Possible values**: `New`, `Mint`, `Very Good`, `Good`, `Acceptable`, `Poor`, `Club`, `OEM`, `Warranty`, `Refurbished Warranty`, `Refurbished`, `Open Box`, `Any`, and `Other`.")
    public String getConditionSubtypeId() {
        return this.conditionSubtypeId;
    }

    public void setConditionSubtypeId(String conditionSubtypeId) {
        this.conditionSubtypeId = conditionSubtypeId;
    }

    public OrderItem scheduledDeliveryStartDate(String scheduledDeliveryStartDate) {
        this.scheduledDeliveryStartDate = scheduledDeliveryStartDate;
        return this;
    }

    @Schema(description="The start date of the scheduled delivery window in the time zone for the order destination. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format.")
    public String getScheduledDeliveryStartDate() {
        return this.scheduledDeliveryStartDate;
    }

    public void setScheduledDeliveryStartDate(String scheduledDeliveryStartDate) {
        this.scheduledDeliveryStartDate = scheduledDeliveryStartDate;
    }

    public OrderItem scheduledDeliveryEndDate(String scheduledDeliveryEndDate) {
        this.scheduledDeliveryEndDate = scheduledDeliveryEndDate;
        return this;
    }

    @Schema(description="The end date of the scheduled delivery window in the time zone for the order destination. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format.")
    public String getScheduledDeliveryEndDate() {
        return this.scheduledDeliveryEndDate;
    }

    public void setScheduledDeliveryEndDate(String scheduledDeliveryEndDate) {
        this.scheduledDeliveryEndDate = scheduledDeliveryEndDate;
    }

    public OrderItem priceDesignation(String priceDesignation) {
        this.priceDesignation = priceDesignation;
        return this;
    }

    @Schema(description="Indicates that the selling price is a special price that is only available for Amazon Business orders. For more information about the Amazon Business Seller Program, refer to the [Amazon Business website](https://www.amazon.com/b2b/info/amazon-business).   **Possible values**: `BusinessPrice`")
    public String getPriceDesignation() {
        return this.priceDesignation;
    }

    public void setPriceDesignation(String priceDesignation) {
        this.priceDesignation = priceDesignation;
    }

    public OrderItem taxCollection(TaxCollection taxCollection) {
        this.taxCollection = taxCollection;
        return this;
    }

    @Schema(description="")
    public TaxCollection getTaxCollection() {
        return this.taxCollection;
    }

    public void setTaxCollection(TaxCollection taxCollection) {
        this.taxCollection = taxCollection;
    }

    public OrderItem serialNumberRequired(Boolean serialNumberRequired) {
        this.serialNumberRequired = serialNumberRequired;
        return this;
    }

    @Schema(description="When true, the product type for this item has a serial number.   Only returned for Amazon Easy Ship orders.")
    public Boolean isSerialNumberRequired() {
        return this.serialNumberRequired;
    }

    public void setSerialNumberRequired(Boolean serialNumberRequired) {
        this.serialNumberRequired = serialNumberRequired;
    }

    public OrderItem isTransparency(Boolean isTransparency) {
        this.isTransparency = isTransparency;
        return this;
    }

    @Schema(description="When true, the ASIN is enrolled in Transparency. The Transparency serial number that you must submit is determined by:  **1D or 2D Barcode:** This has a **T** logo. Submit either the 29-character alpha-numeric identifier beginning with **AZ** or **ZA**, or the 38-character Serialized Global Trade Item Number (SGTIN). **2D Barcode SN:** Submit the 7- to 20-character serial number barcode, which likely has the prefix **SN**. The serial number is applied to the same side of the packaging as the GTIN (UPC/EAN/ISBN) barcode. **QR code SN:** Submit the URL that the QR code generates.")
    public Boolean isIsTransparency() {
        return this.isTransparency;
    }

    public void setIsTransparency(Boolean isTransparency) {
        this.isTransparency = isTransparency;
    }

    public OrderItem iossNumber(String iossNumber) {
        this.iossNumber = iossNumber;
        return this;
    }

    @Schema(description="The IOSS number of the marketplace. Sellers shipping to the EU from outside the EU must provide this IOSS number to their carrier when Amazon has collected the VAT on the sale.")
    public String getIossNumber() {
        return this.iossNumber;
    }

    public void setIossNumber(String iossNumber) {
        this.iossNumber = iossNumber;
    }

    public OrderItem storeChainStoreId(String storeChainStoreId) {
        this.storeChainStoreId = storeChainStoreId;
        return this;
    }

    @Schema(description="The store chain store identifier. Linked to a specific store in a store chain.")
    public String getStoreChainStoreId() {
        return this.storeChainStoreId;
    }

    public void setStoreChainStoreId(String storeChainStoreId) {
        this.storeChainStoreId = storeChainStoreId;
    }

    public OrderItem deemedResellerCategory(DeemedResellerCategoryEnum deemedResellerCategory) {
        this.deemedResellerCategory = deemedResellerCategory;
        return this;
    }

    @Schema(description="The category of deemed reseller. This applies to selling partners that are not based in the EU and is used to help them meet the VAT Deemed Reseller tax laws in the EU and UK.")
    public DeemedResellerCategoryEnum getDeemedResellerCategory() {
        return this.deemedResellerCategory;
    }

    public void setDeemedResellerCategory(DeemedResellerCategoryEnum deemedResellerCategory) {
        this.deemedResellerCategory = deemedResellerCategory;
    }

    public OrderItem buyerInfo(ItemBuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
        return this;
    }

    @Schema(description="")
    public ItemBuyerInfo getBuyerInfo() {
        return this.buyerInfo;
    }

    public void setBuyerInfo(ItemBuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public OrderItem buyerRequestedCancel(BuyerRequestedCancel buyerRequestedCancel) {
        this.buyerRequestedCancel = buyerRequestedCancel;
        return this;
    }

    @Schema(description="")
    public BuyerRequestedCancel getBuyerRequestedCancel() {
        return this.buyerRequestedCancel;
    }

    public void setBuyerRequestedCancel(BuyerRequestedCancel buyerRequestedCancel) {
        this.buyerRequestedCancel = buyerRequestedCancel;
    }

    public OrderItem serialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
        return this;
    }

    public OrderItem addSerialNumbersItem(String serialNumbersItem) {
        if (this.serialNumbers == null) {
            this.serialNumbers = new ArrayList<String>();
        }
        this.serialNumbers.add(serialNumbersItem);
        return this;
    }

    @Schema(description="A list of serial numbers for electronic products that are shipped to customers. Returned for FBA orders only.")
    public List<String> getSerialNumbers() {
        return this.serialNumbers;
    }

    public void setSerialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    public OrderItem substitutionPreferences(SubstitutionPreferences substitutionPreferences) {
        this.substitutionPreferences = substitutionPreferences;
        return this;
    }

    @Schema(description="")
    public SubstitutionPreferences getSubstitutionPreferences() {
        return this.substitutionPreferences;
    }

    public void setSubstitutionPreferences(SubstitutionPreferences substitutionPreferences) {
        this.substitutionPreferences = substitutionPreferences;
    }

    public OrderItem measurement(Measurement measurement) {
        this.measurement = measurement;
        return this;
    }

    @Schema(description="")
    public Measurement getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public OrderItem shippingConstraints(ShippingConstraints shippingConstraints) {
        this.shippingConstraints = shippingConstraints;
        return this;
    }

    @Schema(description="")
    public ShippingConstraints getShippingConstraints() {
        return this.shippingConstraints;
    }

    public void setShippingConstraints(ShippingConstraints shippingConstraints) {
        this.shippingConstraints = shippingConstraints;
    }

    public OrderItem amazonPrograms(AmazonPrograms amazonPrograms) {
        this.amazonPrograms = amazonPrograms;
        return this;
    }

    @Schema(description="")
    public AmazonPrograms getAmazonPrograms() {
        return this.amazonPrograms;
    }

    public void setAmazonPrograms(AmazonPrograms amazonPrograms) {
        this.amazonPrograms = amazonPrograms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.ASIN, orderItem.ASIN) && Objects.equals(this.sellerSKU, orderItem.sellerSKU) && Objects.equals(this.orderItemId, orderItem.orderItemId) && Objects.equals(this.associatedItems, orderItem.associatedItems) && Objects.equals(this.title, orderItem.title) && Objects.equals(this.quantityOrdered, orderItem.quantityOrdered) && Objects.equals(this.quantityShipped, orderItem.quantityShipped) && Objects.equals(this.productInfo, orderItem.productInfo) && Objects.equals(this.pointsGranted, orderItem.pointsGranted) && Objects.equals(this.itemPrice, orderItem.itemPrice) && Objects.equals(this.shippingPrice, orderItem.shippingPrice) && Objects.equals(this.itemTax, orderItem.itemTax) && Objects.equals(this.shippingTax, orderItem.shippingTax) && Objects.equals(this.shippingDiscount, orderItem.shippingDiscount) && Objects.equals(this.shippingDiscountTax, orderItem.shippingDiscountTax) && Objects.equals(this.promotionDiscount, orderItem.promotionDiscount) && Objects.equals(this.promotionDiscountTax, orderItem.promotionDiscountTax) && Objects.equals(this.promotionIds, orderItem.promotionIds) && Objects.equals(this.coDFee, orderItem.coDFee) && Objects.equals(this.coDFeeDiscount, orderItem.coDFeeDiscount) && Objects.equals(this.isGift, orderItem.isGift) && Objects.equals(this.conditionNote, orderItem.conditionNote) && Objects.equals(this.conditionId, orderItem.conditionId) && Objects.equals(this.conditionSubtypeId, orderItem.conditionSubtypeId) && Objects.equals(this.scheduledDeliveryStartDate, orderItem.scheduledDeliveryStartDate) && Objects.equals(this.scheduledDeliveryEndDate, orderItem.scheduledDeliveryEndDate) && Objects.equals(this.priceDesignation, orderItem.priceDesignation) && Objects.equals(this.taxCollection, orderItem.taxCollection) && Objects.equals(this.serialNumberRequired, orderItem.serialNumberRequired) && Objects.equals(this.isTransparency, orderItem.isTransparency) && Objects.equals(this.iossNumber, orderItem.iossNumber) && Objects.equals(this.storeChainStoreId, orderItem.storeChainStoreId) && Objects.equals((Object)this.deemedResellerCategory, (Object)orderItem.deemedResellerCategory) && Objects.equals(this.buyerInfo, orderItem.buyerInfo) && Objects.equals(this.buyerRequestedCancel, orderItem.buyerRequestedCancel) && Objects.equals(this.serialNumbers, orderItem.serialNumbers) && Objects.equals(this.substitutionPreferences, orderItem.substitutionPreferences) && Objects.equals(this.measurement, orderItem.measurement) && Objects.equals(this.shippingConstraints, orderItem.shippingConstraints) && Objects.equals(this.amazonPrograms, orderItem.amazonPrograms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ASIN, this.sellerSKU, this.orderItemId, this.associatedItems, this.title, this.quantityOrdered, this.quantityShipped, this.productInfo, this.pointsGranted, this.itemPrice, this.shippingPrice, this.itemTax, this.shippingTax, this.shippingDiscount, this.shippingDiscountTax, this.promotionDiscount, this.promotionDiscountTax, this.promotionIds, this.coDFee, this.coDFeeDiscount, this.isGift, this.conditionNote, this.conditionId, this.conditionSubtypeId, this.scheduledDeliveryStartDate, this.scheduledDeliveryEndDate, this.priceDesignation, this.taxCollection, this.serialNumberRequired, this.isTransparency, this.iossNumber, this.storeChainStoreId, this.deemedResellerCategory, this.buyerInfo, this.buyerRequestedCancel, this.serialNumbers, this.substitutionPreferences, this.measurement, this.shippingConstraints, this.amazonPrograms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItem {\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    associatedItems: ").append(this.toIndentedString(this.associatedItems)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    quantityOrdered: ").append(this.toIndentedString(this.quantityOrdered)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    productInfo: ").append(this.toIndentedString(this.productInfo)).append("\n");
        sb.append("    pointsGranted: ").append(this.toIndentedString(this.pointsGranted)).append("\n");
        sb.append("    itemPrice: ").append(this.toIndentedString(this.itemPrice)).append("\n");
        sb.append("    shippingPrice: ").append(this.toIndentedString(this.shippingPrice)).append("\n");
        sb.append("    itemTax: ").append(this.toIndentedString(this.itemTax)).append("\n");
        sb.append("    shippingTax: ").append(this.toIndentedString(this.shippingTax)).append("\n");
        sb.append("    shippingDiscount: ").append(this.toIndentedString(this.shippingDiscount)).append("\n");
        sb.append("    shippingDiscountTax: ").append(this.toIndentedString(this.shippingDiscountTax)).append("\n");
        sb.append("    promotionDiscount: ").append(this.toIndentedString(this.promotionDiscount)).append("\n");
        sb.append("    promotionDiscountTax: ").append(this.toIndentedString(this.promotionDiscountTax)).append("\n");
        sb.append("    promotionIds: ").append(this.toIndentedString(this.promotionIds)).append("\n");
        sb.append("    coDFee: ").append(this.toIndentedString(this.coDFee)).append("\n");
        sb.append("    coDFeeDiscount: ").append(this.toIndentedString(this.coDFeeDiscount)).append("\n");
        sb.append("    isGift: ").append(this.toIndentedString(this.isGift)).append("\n");
        sb.append("    conditionNote: ").append(this.toIndentedString(this.conditionNote)).append("\n");
        sb.append("    conditionId: ").append(this.toIndentedString(this.conditionId)).append("\n");
        sb.append("    conditionSubtypeId: ").append(this.toIndentedString(this.conditionSubtypeId)).append("\n");
        sb.append("    scheduledDeliveryStartDate: ").append(this.toIndentedString(this.scheduledDeliveryStartDate)).append("\n");
        sb.append("    scheduledDeliveryEndDate: ").append(this.toIndentedString(this.scheduledDeliveryEndDate)).append("\n");
        sb.append("    priceDesignation: ").append(this.toIndentedString(this.priceDesignation)).append("\n");
        sb.append("    taxCollection: ").append(this.toIndentedString(this.taxCollection)).append("\n");
        sb.append("    serialNumberRequired: ").append(this.toIndentedString(this.serialNumberRequired)).append("\n");
        sb.append("    isTransparency: ").append(this.toIndentedString(this.isTransparency)).append("\n");
        sb.append("    iossNumber: ").append(this.toIndentedString(this.iossNumber)).append("\n");
        sb.append("    storeChainStoreId: ").append(this.toIndentedString(this.storeChainStoreId)).append("\n");
        sb.append("    deemedResellerCategory: ").append(this.toIndentedString((Object)this.deemedResellerCategory)).append("\n");
        sb.append("    buyerInfo: ").append(this.toIndentedString(this.buyerInfo)).append("\n");
        sb.append("    buyerRequestedCancel: ").append(this.toIndentedString(this.buyerRequestedCancel)).append("\n");
        sb.append("    serialNumbers: ").append(this.toIndentedString(this.serialNumbers)).append("\n");
        sb.append("    substitutionPreferences: ").append(this.toIndentedString(this.substitutionPreferences)).append("\n");
        sb.append("    measurement: ").append(this.toIndentedString(this.measurement)).append("\n");
        sb.append("    shippingConstraints: ").append(this.toIndentedString(this.shippingConstraints)).append("\n");
        sb.append("    amazonPrograms: ").append(this.toIndentedString(this.amazonPrograms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeemedResellerCategoryEnum {
        IOSS("IOSS"),
        UOSS("UOSS");

        private String value;

        private DeemedResellerCategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeemedResellerCategoryEnum fromValue(String input) {
            for (DeemedResellerCategoryEnum b : DeemedResellerCategoryEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DeemedResellerCategoryEnum> {
            public void write(JsonWriter jsonWriter, DeemedResellerCategoryEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public DeemedResellerCategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeemedResellerCategoryEnum.fromValue(value);
            }
        }
    }
}

