/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Measurement information for an order item.")
public class Measurement {
    @SerializedName(value="Unit")
    private UnitEnum unit = null;
    @SerializedName(value="Value")
    private BigDecimal value = null;

    public Measurement unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @Schema(required=true, description="The unit of measure.")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public Measurement value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="The measurement value.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement measurement = (Measurement)o;
        return Objects.equals((Object)this.unit, (Object)measurement.unit) && Objects.equals(this.value, measurement.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unit, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Measurement {\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        OUNCES("OUNCES"),
        POUNDS("POUNDS"),
        KILOGRAMS("KILOGRAMS"),
        GRAMS("GRAMS"),
        MILLIGRAMS("MILLIGRAMS"),
        INCHES("INCHES"),
        FEET("FEET"),
        METERS("METERS"),
        CENTIMETERS("CENTIMETERS"),
        MILLIMETERS("MILLIMETERS"),
        SQUARE_METERS("SQUARE_METERS"),
        SQUARE_CENTIMETERS("SQUARE_CENTIMETERS"),
        SQUARE_FEET("SQUARE_FEET"),
        SQUARE_INCHES("SQUARE_INCHES"),
        GALLONS("GALLONS"),
        PINTS("PINTS"),
        QUARTS("QUARTS"),
        FLUID_OUNCES("FLUID_OUNCES"),
        LITERS("LITERS"),
        CUBIC_METERS("CUBIC_METERS"),
        CUBIC_FEET("CUBIC_FEET"),
        CUBIC_INCHES("CUBIC_INCHES"),
        CUBIC_CENTIMETERS("CUBIC_CENTIMETERS"),
        COUNT("COUNT");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String input) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(value);
            }
        }
    }
}

